/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tipsmod.common.impl.client;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Objects;
import net.darkhax.tipsmod.common.api.tips.ITip;
import net.darkhax.tipsmod.common.impl.TipsMod;
import net.darkhax.tipsmod.common.impl.client.TipManager;
import net.darkhax.tipsmod.common.impl.config.Config;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;

public class TipRenderer {
    public static final TipRenderer INSTANCE = new TipRenderer();
    private long initTime = System.currentTimeMillis();
    @Nullable
    private ITip tip;
    @Nullable
    private WeakReference<class_437> lastScreen;
    private int rngIndex = 0;

    private void setTip(ITip newTip) {
        this.tip = newTip;
        this.initTime = System.currentTimeMillis();
    }

    @Nullable
    private ITip getNextTip(class_437 parentScreen) {
        List<ITip> shuffledTips = TipManager.INSTANCE.getTips().stream().filter(tip -> tip.canDisplayOnScreen(parentScreen)).toList();
        if (!shuffledTips.isEmpty() && this.rngIndex + 1 > shuffledTips.size()) {
            this.rngIndex = 0;
        }
        return shuffledTips.isEmpty() ? null : shuffledTips.get(this.rngIndex++);
    }

    public void drawTip(class_332 graphics, class_437 parentScreen) {
        if (!(this.tip != null || this.lastScreen != null && this.lastScreen.refersTo(parentScreen))) {
            this.setTip(this.getNextTip(parentScreen));
            this.lastScreen = new WeakReference<class_437>(parentScreen);
        }
        if (this.tip != null) {
            int currentCycleTime;
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.initTime > (long)(currentCycleTime = this.tip.getCycleTime())) {
                this.setTip(this.getNextTip(parentScreen));
            }
            if (this.tip != null && this.tip.canDisplayOnScreen(parentScreen)) {
                int textWidth = class_3532.method_15375((float)((float)parentScreen.field_22789 * ((Config)TipsMod.CONFIG.get()).tip_render_width_percentage));
                int height = parentScreen.field_22790 - 10;
                height -= TipRenderer.renderLinesReversed(graphics, 10, height, (class_5348)this.tip.getText(), textWidth);
                TipRenderer.renderLinesReversed(graphics, 10, height -= 3, (class_5348)this.tip.getTitle(), textWidth);
            }
        }
    }

    private static int renderLinesReversed(class_332 graphics, int x, int y, class_5348 text, int textWidth) {
        class_327 font = class_310.method_1551().field_1772;
        Objects.requireNonNull(font);
        return TipRenderer.renderLinesReversed(graphics, font, x, y, 9, 0xFFFFFF, text, textWidth);
    }

    private static int renderLinesReversed(class_332 graphics, class_327 font, int x, int y, int spacing, int defaultColor, class_5348 text, int textWidth) {
        return TipRenderer.renderLinesReversed(graphics, font, x, y, spacing, defaultColor, font.method_1728(text, textWidth));
    }

    private static int renderLinesReversed(class_332 graphics, class_327 font, int x, int y, int spacing, int defaultColor, List<class_5481> lines) {
        int lineCount = lines.size();
        for (int lineNum = lineCount - 1; lineNum >= 0; --lineNum) {
            class_5481 lineFragment = lines.get(lineCount - 1 - lineNum);
            graphics.method_35720(font, lineFragment, x, y - (lineNum + 1) * (spacing + 1), defaultColor);
        }
        return lineCount * (spacing + 1);
    }
}

