/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tipsmod.common.impl.client.tips;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Set;
import net.darkhax.bookshelf.common.api.data.codecs.map.MapCodecHelper;
import net.darkhax.bookshelf.common.api.data.codecs.map.MapCodecs;
import net.darkhax.tipsmod.common.api.TipsAPI;
import net.darkhax.tipsmod.common.api.tips.ITip;
import net.darkhax.tipsmod.common.api.tips.TipType;
import net.darkhax.tipsmod.common.impl.TipsMod;
import net.darkhax.tipsmod.common.impl.client.tips.conditions.ConditionRules;
import net.darkhax.tipsmod.common.impl.client.tips.conditions.RuleBuilders;
import net.darkhax.tipsmod.common.impl.config.Config;
import net.darkhax.tipsmod.common.impl.resources.Helpers;
import net.minecraft.class_1959;
import net.minecraft.class_2561;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_6880;
import net.minecraft.class_746;

public class SimpleTip
implements ITip {
    public static final class_2960 TYPE_ID = TipsMod.id("simple");
    public static final MapCodec<SimpleTip> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MapCodecs.TEXT.get("title", ITip::getTitle, (Object)((Config)TipsMod.CONFIG.get()).default_title), (App)MapCodecs.TEXT.get("text", ITip::getText), (App)MapCodecs.INT.get("cycle_time", ITip::getCycleTime, (Object)((Config)TipsMod.CONFIG.get()).default_cycle_time), (App)Conditions.CODEC.get("conditions", SimpleTip::getConditions, (Object)Conditions.EMPTY)).apply((Applicative)instance, SimpleTip::new));
    private final class_2561 title;
    private final class_2561 text;
    private final int cycleTime;
    private final Conditions conditions;

    public SimpleTip(class_2561 title, class_2561 text, int cycleTime, Conditions conditions) {
        this.title = title;
        this.text = text;
        this.cycleTime = cycleTime;
        this.conditions = conditions;
    }

    protected Conditions getConditions() {
        return null;
    }

    @Override
    public class_2561 getTitle() {
        return this.title;
    }

    @Override
    public class_2561 getText() {
        return this.text;
    }

    @Override
    public TipType getType() {
        return TipsMod.SIMPLE_TYPE;
    }

    @Override
    public int getCycleTime() {
        return this.cycleTime;
    }

    @Override
    public boolean canDisplayOnScreen(class_437 screen) {
        return this.conditions.canDisplayOnScreen(screen);
    }

    public record Conditions(Optional<ConditionRules<class_437>> screens, Optional<ConditionRules<class_6880<class_1959>>> biome, Optional<ConditionRules<class_6880<class_2874>>> dimension, Optional<ConditionRules<Set<class_2960>>> advancements) {
        public static final Conditions EMPTY = new Conditions(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        public static final MapCodecHelper<Conditions> CODEC = new MapCodecHelper(RecordCodecBuilder.create(instance -> instance.group((App)ConditionRules.codecOf(RuleBuilders.SCREEN).getOptional("screens", Conditions::screens), (App)ConditionRules.codecOf(RuleBuilders.BIOME).getOptional("biomes", Conditions::biome), (App)ConditionRules.codecOf(RuleBuilders.DIMENSION).getOptional("dimensions", Conditions::dimension), (App)ConditionRules.codecOf(RuleBuilders.RESOURCE_LOCATION_SET).getOptional("advancements", Conditions::advancements)).apply((Applicative)instance, Conditions::new)), (Object[])new Conditions[0]);

        public boolean isEmpty() {
            return this.screens.isEmpty() && this.biome.isEmpty() && this.dimension().isEmpty() && this.advancements().isEmpty();
        }

        public boolean requiresPlayer() {
            return this.biome.isPresent() || this.dimension.isPresent() || this.advancements.isPresent();
        }

        public boolean canDisplayOnScreen(class_437 screen) {
            if (this.screens.map(rules -> rules.test(screen)).orElseGet(() -> TipsAPI.isDefaultScreen(screen)).booleanValue()) {
                if (this.requiresPlayer()) {
                    class_746 player = class_310.method_1551().field_1724;
                    if (player == null) {
                        return false;
                    }
                    if (this.biome.isPresent() && !this.biome.get().test((class_6880<class_1959>)player.method_37908().method_23753(player.method_24515()))) {
                        return false;
                    }
                    if (this.dimension.isPresent() && !this.dimension.get().test((class_6880<class_2874>)player.method_37908().method_40134())) {
                        return false;
                    }
                    if (this.advancements.isPresent() && !this.advancements.get().test(Helpers.getCompletedAdvancements(player))) {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
    }
}

