/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tipsmod.common.impl.client.tips.conditions;

import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.darkhax.tipsmod.common.api.TipsAPI;
import net.darkhax.tipsmod.common.impl.TipsMod;
import net.darkhax.tipsmod.common.impl.client.tips.conditions.IRuleBuilder;
import net.darkhax.tipsmod.common.impl.client.tips.conditions.VanillaScreenIds;
import net.darkhax.tipsmod.common.impl.resources.Helpers;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class RuleBuilders {
    public static final IRuleBuilder<class_437> SCREEN = rule -> {
        if (rule.equalsIgnoreCase("tipsmod:built-in")) {
            return TipsAPI::isDefaultScreen;
        }
        if (Helpers.isValid(rule)) {
            class_2960 targetScreen = class_2960.method_12829((String)rule);
            if (targetScreen != null && "minecraft".equalsIgnoreCase(targetScreen.method_12836())) {
                return screen -> VanillaScreenIds.is(targetScreen, screen.getClass());
            }
        } else {
            if (rule.contains(".")) {
                return screen -> rule.equalsIgnoreCase(screen.getClass().getCanonicalName());
            }
            return screen -> rule.equals(screen.getClass().getSimpleName());
        }
        TipsMod.LOG.error("Screen condition with ID {} is not valid. Only the vanilla screens have IDs.", (Object)rule);
        return screen -> false;
    };
    public static final IRuleBuilder<class_2960> RESOURCE_LOCATION = rule -> {
        if (Helpers.isValid(rule)) {
            class_2960 targetEntryID = class_2960.method_12829((String)rule);
            return targetEntryID == null ? entry -> false : entry -> entry.equals((Object)targetEntryID);
        }
        if (Helpers.isNamespace(rule)) {
            return entry -> rule.equalsIgnoreCase(entry.method_12836());
        }
        if (rule.startsWith("~")) {
            try {
                Pattern pattern = Pattern.compile(rule);
                return entry -> pattern.matcher(entry.toString()).matches();
            }
            catch (PatternSyntaxException e) {
                TipsMod.LOG.error("An invalid Regex pattern was used! Rule '{}' is invalid!", (Object)rule, (Object)e);
                return entry -> false;
            }
        }
        TipsMod.LOG.error("An invalid pattern was used. Pattern must be a valid resource location, namespace, or regex pattern. '{}'", (Object)rule);
        return entry -> false;
    };
    public static final IRuleBuilder<Set<class_2960>> RESOURCE_LOCATION_SET = rule -> {
        Predicate<class_2960> rlRule = RESOURCE_LOCATION.build(rule);
        return set -> set.stream().anyMatch(rlRule);
    };
    public static final IRuleBuilder<class_6880<class_1959>> BIOME = rule -> RuleBuilders.buildRegistryRule(class_7924.field_41236, rule);
    public static final IRuleBuilder<class_6880<class_2874>> DIMENSION = rule -> RuleBuilders.buildRegistryRule(class_7924.field_41241, rule);

    private static <T> Predicate<class_6880<T>> buildRegistryRule(class_5321<? extends class_2378<T>> regKey, String rule) {
        if (Helpers.isValid(rule)) {
            class_2960 targetEntryID = class_2960.method_12829((String)rule);
            return targetEntryID == null ? entry -> false : entry -> entry.method_40226(targetEntryID);
        }
        if (Helpers.isNamespace(rule)) {
            return entry -> entry.method_40230().map(id -> rule.equalsIgnoreCase(id.method_29177().method_12836())).orElse(false);
        }
        if (rule.startsWith("#") && Helpers.isValid(rule.substring(1))) {
            class_6862 tag = class_6862.method_40092(regKey, (class_2960)Objects.requireNonNull(class_2960.method_12829((String)rule.substring(1))));
            return entry -> entry.method_40220(tag);
        }
        if (rule.startsWith("~")) {
            try {
                Pattern pattern = Pattern.compile(rule);
                return entry -> entry.method_40230().map(key -> pattern.matcher(key.toString()).matches()).orElse(false);
            }
            catch (PatternSyntaxException e) {
                TipsMod.LOG.error("An invalid Regex pattern was used! Rule '{}' is invalid!", (Object)rule, (Object)e);
                return entry -> false;
            }
        }
        TipsMod.LOG.error("An invalid pattern was used. Pattern must be a valid resource location, namespace, tag, or regex pattern. '{}'", (Object)rule);
        return entry -> false;
    }
}

