/*
 * Decompiled with CFR 0.152.
 */
package dev.sciwhiz12.snowyweaponry.entity;

import dev.sciwhiz12.snowyweaponry.Reference;
import dev.sciwhiz12.snowyweaponry.item.CoredSnowballItem;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CoredSnowball
extends Snowball {
    public CoredSnowball(EntityType<CoredSnowball> entityType, Level level) {
        super(entityType, level);
    }

    public CoredSnowball(Level level, double x, double y, double z, ItemStack stack) {
        super((EntityType)Reference.EntityTypes.CORED_SNOWBALL.get(), level);
        this.setPos(x, y, z);
        this.setItem(stack);
    }

    public CoredSnowball(Level level, LivingEntity thrower, ItemStack stack) {
        this(level, thrower.getX(), thrower.getEyeY() - 0.1, thrower.getZ(), stack);
        this.setOwner((Entity)thrower);
    }

    protected Item getDefaultItem() {
        return (Item)Reference.Items.IRON_CORED_SNOWBALL.get();
    }

    protected Component getTypeName() {
        ItemStack stack = this.getItem();
        if (!stack.isEmpty()) {
            return stack.getHoverName();
        }
        return super.getTypeName();
    }

    protected void onHitEntity(EntityHitResult result) {
        Item item;
        ItemStack stack = this.getItem();
        Entity entity = result.getEntity();
        int damage = 0;
        if (entity.getType().is(Reference.Tags.FIRE_MOBS)) {
            damage += 3;
        }
        if ((item = stack.getItem()) instanceof CoredSnowballItem) {
            CoredSnowballItem item2 = (CoredSnowballItem)item;
            damage = item2.getDamage();
            @Nullable MobEffectInstance effect = item2.getHitEffect();
            if (effect != null && entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.addEffect(new MobEffectInstance(effect));
            }
        }
        entity.hurt(this.damageSources().source(Reference.DamageTypes.CORED_SNOWBALL, (Entity)this, this.getOwner()), (float)damage);
    }
}

