/*
 * Decompiled with CFR 0.152.
 */
package dev.sciwhiz12.snowyweaponry.entity;

import dev.sciwhiz12.snowyweaponry.Reference;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;

public class ExplosiveSnowball
extends Snowball {
    public static final float EXPLOSION_POWER = 1.2f;

    public ExplosiveSnowball(EntityType<ExplosiveSnowball> entityType, Level level) {
        super(entityType, level);
    }

    public ExplosiveSnowball(Level level, double x, double y, double z, ItemStack stack) {
        super((EntityType)Reference.EntityTypes.EXPLOSIVE_SNOWBALL.get(), level);
        this.setPos(x, y, z);
        this.setItem(stack);
    }

    public ExplosiveSnowball(Level level, LivingEntity thrower, ItemStack stack) {
        this(level, thrower.getX(), thrower.getEyeY() - 0.1, thrower.getZ(), stack);
        this.setOwner((Entity)thrower);
    }

    protected Item getDefaultItem() {
        return (Item)Reference.Items.EXPLOSIVE_SNOWBALL.get();
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        Level level = this.level();
        if (!level.isClientSide()) {
            Registry damageTypes = (Registry)level.registryAccess().lookup(Registries.DAMAGE_TYPE).orElseThrow();
            Holder.Reference damageType = damageTypes.getOrThrow(Reference.DamageTypes.CORED_SNOWBALL_EXPLOSION);
            level.explode((Entity)this, new DamageSource((Holder)damageType, (Entity)this, this.getOwner()), null, this.getX(), this.getY(), this.getZ(), 1.2f, false, Level.ExplosionInteraction.NONE);
        }
    }
}

