/*
 * Decompiled with CFR 0.152.
 */
package dev.sciwhiz12.snowyweaponry.item;

import dev.sciwhiz12.snowyweaponry.entity.CoredSnowball;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.Level;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CoredSnowballItem
extends Item
implements ProjectileItem {
    private final int thrownDamage;
    private final int lootingLevel;
    private final @Nullable Supplier<MobEffectInstance> hitEffect;

    public CoredSnowballItem(Item.Properties properties, int thrownDamage, int lootingLevel, @Nullable Supplier<MobEffectInstance> hitEffect) {
        super(properties);
        this.thrownDamage = thrownDamage;
        this.lootingLevel = lootingLevel;
        this.hitEffect = hitEffect;
    }

    public CoredSnowballItem(Item.Properties properties, int thrownDamage, int lootingLevel) {
        this(properties, thrownDamage, lootingLevel, null);
    }

    public int getDamage() {
        return this.thrownDamage;
    }

    public int getLootingLevel() {
        return this.lootingLevel;
    }

    public @Nullable MobEffectInstance getHitEffect() {
        return this.hitEffect != null ? this.hitEffect.get() : null;
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.SNOWBALL_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            Projectile.spawnProjectileFromRotation(CoredSnowball::new, (ServerLevel)serverlevel, (ItemStack)stack, (LivingEntity)player, (float)0.0f, (float)1.5f, (float)1.0f);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        stack.consume(1, (LivingEntity)player);
        return InteractionResult.SUCCESS;
    }

    public Projectile asProjectile(Level level, Position pos, ItemStack stack, Direction direction) {
        return new CoredSnowball(level, pos.x(), pos.y(), pos.z(), stack);
    }
}

