/*
 * Decompiled with CFR 0.152.
 */
package dev.sciwhiz12.snowyweaponry.jei;

import dev.sciwhiz12.snowyweaponry.Reference;
import dev.sciwhiz12.snowyweaponry.SnowyWeaponry;
import dev.sciwhiz12.snowyweaponry.item.PotionConeItem;
import dev.sciwhiz12.snowyweaponry.jei.PotionSubtypeInterpreter;
import java.util.List;
import java.util.Map;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentExactPredicate;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;

@JeiPlugin
public class JeiIntegration
implements IModPlugin {
    private static final ResourceLocation PLUGIN_UID = SnowyWeaponry.loc("jei_plugin");

    public ResourceLocation getPluginUid() {
        return PLUGIN_UID;
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)Reference.Items.POTION_SNOW_CONE.get(), (ISubtypeInterpreter)PotionSubtypeInterpreter.INSTANCE);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        List<RecipeHolder<CraftingRecipe>> recipes = JeiIntegration.createPotionConeRecipes();
        registration.addRecipes((IRecipeType)RecipeTypes.CRAFTING, recipes);
    }

    private static List<RecipeHolder<CraftingRecipe>> createPotionConeRecipes() {
        Ingredient cone = Ingredient.of(Reference.Items.SNOW_CONE);
        return BuiltInRegistries.POTION.listElements().map(potion -> {
            Ingredient potionIngredient = DataComponentIngredient.of((boolean)false, (DataComponentExactPredicate)DataComponentExactPredicate.expect((DataComponentType)DataComponents.POTION_CONTENTS, (Object)new PotionContents((Holder)potion)), (ItemLike[])new ItemLike[]{Items.POTION, Items.SPLASH_POTION});
            ItemStack output = PotionConeItem.createItemStack(4, (Holder<Potion>)potion);
            ShapedRecipePattern pattern = ShapedRecipePattern.of(Map.of(Character.valueOf('C'), cone, Character.valueOf('P'), potionIngredient), List.of(" C ", "CPC", " C "));
            return new RecipeHolder(ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)SnowyWeaponry.loc(output.getItem().getDescriptionId())), (Recipe)new ShapedRecipe(output.getItem().getDescriptionId(), CraftingBookCategory.MISC, pattern, output));
        }).toList();
    }
}

