/*
 * Decompiled with CFR 0.152.
 */
package dev.sciwhiz12.snowyweaponry.recipe;

import dev.sciwhiz12.snowyweaponry.Reference;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PotionConeRecipe
extends CustomRecipe {
    public PotionConeRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput input, Level level) {
        if (input.width() * input.height() < 5) {
            return false;
        }
        boolean hasPotion = false;
        int cones = 0;
        for (int i = 0; i < input.width(); ++i) {
            for (int j = 0; j < input.height(); ++j) {
                ItemStack itemstack = input.getItem(i + j * input.width());
                Item item = itemstack.getItem();
                if (item == Items.POTION || item == Items.SPLASH_POTION) {
                    if (!hasPotion) {
                        hasPotion = true;
                        continue;
                    }
                    return false;
                }
                if (item != Reference.Items.SNOW_CONE.get() || cones++ <= 4) continue;
                return false;
            }
        }
        return hasPotion && cones == 4;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider holderLookup) {
        ItemStack potion = ItemStack.EMPTY;
        for (int i = 0; i < input.width(); ++i) {
            for (int j = 0; j < input.height(); ++j) {
                ItemStack stack = input.getItem(i + j * input.width());
                Item item = stack.getItem();
                if (item != Items.POTION && item != Items.SPLASH_POTION) continue;
                potion = stack;
            }
        }
        if (potion.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack ret = Reference.Items.POTION_SNOW_CONE.toStack(4);
        @Nullable PotionContents potionContents = (PotionContents)potion.get(DataComponents.POTION_CONTENTS);
        if (potionContents != null) {
            ret.set(DataComponents.POTION_CONTENTS, (Object)potionContents);
        }
        return ret;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput input) {
        NonNullList remaining = NonNullList.withSize((int)input.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < remaining.size(); ++i) {
            ItemStack item = input.getItem(i);
            if (item.is(Items.POTION)) {
                remaining.set(i, (Object)new ItemStack((ItemLike)Items.GLASS_BOTTLE));
                continue;
            }
            remaining.set(i, (Object)item.getCraftingRemainder());
        }
        return remaining;
    }

    public RecipeSerializer<? extends CustomRecipe> getSerializer() {
        return (RecipeSerializer)Reference.RecipeSerializers.POTION_CONE_RECIPE.get();
    }
}

