/*
 * Decompiled with CFR 0.152.
 */
package com.convallyria.hugestructureblocks.mixin.structure;

import com.convallyria.hugestructureblocks.cache.WorldStructureBlockCacheAccessor;
import java.util.Comparator;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.properties.StructureMode;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.ModifyConstant;

@Mixin(value={StructureBlockEntity.class}, priority=999)
public class StructureBlockUnlimit {
    @ModifyConstant(method={"loadAdditional(Lnet/minecraft/world/level/storage/ValueInput;)V"}, constant={@Constant(intValue=48)}, require=0)
    public int readNbtUpper(int value) {
        return 512;
    }

    @ModifyConstant(method={"loadAdditional(Lnet/minecraft/world/level/storage/ValueInput;)V"}, constant={@Constant(intValue=-48)}, require=0)
    public int readNbtLower(int value) {
        return -512;
    }

    @Overwrite
    private Stream<BlockPos> getRelatedCorners(BlockPos min, BlockPos max) {
        StructureBlockEntity origin = (StructureBlockEntity)this;
        String template = origin.getStructureName();
        if (template == null) {
            return Stream.empty();
        }
        BlockPos middle = origin.getBlockPos();
        Level level = origin.getLevel();
        if (level == null) {
            return Stream.empty();
        }
        WorldStructureBlockCacheAccessor cache = (WorldStructureBlockCacheAccessor)level;
        return cache.huge_structure_blocks$getStructureBlockCache().getAll().filter(pos -> !pos.equals((Object)middle)).filter(pos -> pos.closerThan((Vec3i)middle, (double)(this.detectSize(-1) + 1))).map(arg_0 -> ((Level)level).getBlockEntity(arg_0)).filter(be -> {
            StructureBlockEntity block;
            return be instanceof StructureBlockEntity && (block = (StructureBlockEntity)be).getMode() == StructureMode.CORNER && template.equals(block.getStructureName());
        }).map(BlockEntity::getBlockPos).sorted(Comparator.comparingDouble(pos -> pos.distSqr((Vec3i)middle))).limit(2L);
    }

    @ModifyConstant(method={"detectSize()Z"}, constant={@Constant(intValue=80)}, require=0)
    public int detectSize(int value) {
        return 512;
    }
}

