/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.petrolsparts.content.chained_cogwheel;

import com.petrolpark.petrolsparts.content.chained_cogwheel.IChainableBlock;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ChainedCogwheelBlockEntity
extends BracketedKineticBlockEntity {
    public BlockPos partner;
    public boolean controller = false;
    public BlockState copiedState;

    public ChainedCogwheelBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public List<BlockPos> addPropagationLocations(IRotate block, BlockState state, List<BlockPos> neighbours) {
        neighbours.add(this.getBlockPos().offset((Vec3i)this.partner));
        return neighbours;
    }

    public float propagateRotationTo(KineticBlockEntity target, BlockState stateFrom, BlockState stateTo, BlockPos diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        if (diff.equals((Object)this.partner) && target instanceof ChainedCogwheelBlockEntity) {
            ChainedCogwheelBlockEntity otherGear = (ChainedCogwheelBlockEntity)target;
            return IChainableBlock.getPropagatedSpeed(otherGear.copiedState) / IChainableBlock.getPropagatedSpeed(this.copiedState);
        }
        return super.propagateRotationTo(target, stateFrom, stateTo, diff, connectedViaAxes, connectedViaCogs);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.partner = NbtUtils.readBlockPos((CompoundTag)compound, (String)"PartnerPos").orElse(null);
        this.controller = compound.getBoolean("Controller");
        this.copiedState = NbtUtils.readBlockState((HolderGetter)this.blockHolderGetter(), (CompoundTag)compound.getCompound("CopiedState"));
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.put("PartnerPos", NbtUtils.writeBlockPos((BlockPos)this.partner));
        compound.putBoolean("Controller", this.controller);
        compound.put("CopiedState", (Tag)NbtUtils.writeBlockState((BlockState)this.copiedState));
    }
}

