/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.petrolsparts.content.chained_cogwheel;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.petrolpark.petrolsparts.content.chained_cogwheel.ChainedCogwheelBlockEntity;
import com.petrolpark.petrolsparts.content.chained_cogwheel.IChainableBlock;
import com.petrolpark.util.MathsHelper;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.simpleRelays.SimpleKineticBlockEntity;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ChainedCogwheelRenderer
extends KineticBlockEntityRenderer<ChainedCogwheelBlockEntity> {
    public static final double linkLength = 0.25;

    public ChainedCogwheelRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(ChainedCogwheelBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (VisualizationManager.supportsVisualization((LevelAccessor)be.getLevel())) {
            return;
        }
        BlockState state = this.getRenderedBlockState(be);
        if (state == null) {
            return;
        }
        Direction.Axis axis = ChainedCogwheelRenderer.getRotationAxisOf((KineticBlockEntity)be);
        VertexConsumer vc = buffer.getBuffer(RenderType.solid());
        Direction facing = Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)be.getLevel());
        float targetAngle = time * be.getSpeed() * 3.0f / 10.0f % 360.0f;
        if (be.controller && be.hasLevel()) {
            BlockEntity otherBE = be.getLevel().getBlockEntity(new BlockPos(MathsHelper.add((Vec3i)be.getBlockPos(), (Vec3i)be.partner)));
            if (!(otherBE instanceof ChainedCogwheelBlockEntity)) {
                return;
            }
            ChainedCogwheelBlockEntity otherCBE = (ChainedCogwheelBlockEntity)otherBE;
            ms.pushPose();
            for (Pair<Vec3, Float> pair : ChainedCogwheelRenderer.getLinkPositionsAndRotations(axis, state, be.partner, otherCBE.copiedState, targetAngle)) {
            }
            ms.popPose();
        }
        if (AllBlocks.LARGE_COGWHEEL.has(state)) {
            ChainedCogwheelRenderer.renderRotatingBuffer((KineticBlockEntity)be, (SuperByteBuffer)CachedBuffers.partialFacingVertical((PartialModel)AllPartialModels.SHAFTLESS_LARGE_COGWHEEL, (BlockState)be.getBlockState(), (Direction)facing), (PoseStack)ms, (VertexConsumer)vc, (int)light);
            float angle = BracketedKineticBlockEntityRenderer.getAngleForLargeCogShaft((SimpleKineticBlockEntity)be, (Direction.Axis)axis);
            SuperByteBuffer shaft = CachedBuffers.partialFacingVertical((PartialModel)AllPartialModels.COGWHEEL_SHAFT, (BlockState)be.getBlockState(), (Direction)facing);
            ChainedCogwheelRenderer.kineticRotationTransform((SuperByteBuffer)shaft, (KineticBlockEntity)be, (Direction.Axis)axis, (float)angle, (int)light);
            shaft.renderInto(ms, vc);
        } else {
            super.renderSafe((KineticBlockEntity)be, partialTicks, ms, buffer, light, overlay);
        }
    }

    public static List<Pair<Vec3, Float>> getLinkPositionsAndRotations(Direction.Axis axis, BlockState thisCog, BlockPos otherPos, BlockState otherCog, float cogAngle) {
        Vec3 thisCenter = IChainableBlock.getRelativeCenterOfRotation(thisCog);
        Vec3 thatCenter = Vec3.atLowerCornerOf((Vec3i)otherPos).add(IChainableBlock.getRelativeCenterOfRotation(otherCog));
        Vec3 thisToThat = thatCenter.subtract(thisCenter);
        double d = thisToThat.length();
        double r1 = IChainableBlock.getRadius(thisCog);
        double r2 = IChainableBlock.getRadius(otherCog);
        double l = Math.sqrt(d * d - (r1 - r2) * (r1 - r2));
        Vec3 forward = new Vec3(axis == Direction.Axis.Y ? Direction.EAST.step() : Direction.UP.step());
        Vec3 up = new Vec3(Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis).step());
        double angleToThat = MathsHelper.angleBetween((Vec3)forward, (Vec3)thatCenter.subtract(thisCenter), (Vec3)up);
        double angle1 = Math.acos((r1 - r2) / d) * 180.0 / 3.1415927410125732;
        double angle2 = 180.0 - angle1;
        ArrayList<Pair<Vec3, Float>> pandrs = new ArrayList<Pair<Vec3, Float>>();
        return pandrs;
    }

    protected BlockState getRenderedBlockState(ChainedCogwheelBlockEntity be) {
        return be.copiedState;
    }
}

