/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.petrolsparts.content.chained_cogwheel;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public interface IChainableBlock
extends ICogWheel {
    public static final Vec3 CENTER_OFFSET = new Vec3(0.5, 0.5, 0.5);

    public static boolean isStateChainable(BlockState state) {
        IChainableBlock chainable;
        Block block = state.getBlock();
        return block instanceof IChainableBlock && (chainable = (IChainableBlock)block).isChainable(state) || AllBlocks.COGWHEEL.has(state) || AllBlocks.LARGE_COGWHEEL.has(state);
    }

    public static float getPropagatedSpeed(BlockState state) {
        Block block = state.getBlock();
        if (block instanceof IChainableBlock) {
            IChainableBlock chainable = (IChainableBlock)block;
            return chainable.chainSpeedMultiplier(state);
        }
        if (ICogWheel.isLargeCog((BlockState)state)) {
            return 0.5f;
        }
        return 1.0f;
    }

    public static Vec3 getRelativeCenterOfRotation(BlockState state) {
        Block block = state.getBlock();
        if (block instanceof IChainableBlock) {
            IChainableBlock chainable = (IChainableBlock)block;
            return chainable.getCenterOfRotation(state);
        }
        return CENTER_OFFSET;
    }

    public static float getRadius(BlockState state) {
        Block block = state.getBlock();
        if (block instanceof IChainableBlock) {
            IChainableBlock chainable = (IChainableBlock)block;
            return chainable.getChainRadius(state);
        }
        if (ICogWheel.isLargeCog((BlockState)state)) {
            return 0.9375f;
        }
        return 0.5625f;
    }

    default public boolean isChainable(BlockState state) {
        return true;
    }

    default public float chainSpeedMultiplier(BlockState state) {
        return this.isLargeCog() ? 0.5f : 1.0f;
    }

    default public Vec3 getCenterOfRotation(BlockState state) {
        return CENTER_OFFSET;
    }

    default public float getChainRadius(BlockState state) {
        if (this.isLargeCog()) {
            return 0.9375f;
        }
        return 0.5625f;
    }
}

