/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.petrolsparts.content.coaxial_gear;

import com.petrolpark.petrolsparts.PetrolsPartsBlockEntityTypes;
import com.petrolpark.petrolsparts.PetrolsPartsBlocks;
import com.petrolpark.petrolsparts.content.coaxial_gear.CoaxialGearBlock;
import com.petrolpark.petrolsparts.core.advancement.PetrolsPartsAdvancementBehaviour;
import com.petrolpark.petrolsparts.core.advancement.PetrolsPartsAdvancementTriggers;
import com.petrolpark.petrolsparts.core.block.DirectionalRotatedPillarKineticBlock;
import com.petrolpark.util.KineticsHelper;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CoaxialGearBlockEntity
extends BracketedKineticBlockEntity {
    protected PetrolsPartsAdvancementBehaviour advancementBehaviour;

    public CoaxialGearBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.advancementBehaviour = new PetrolsPartsAdvancementBehaviour((SmartBlockEntity)this, PetrolsPartsAdvancementTriggers.COAXIAL_GEAR);
        behaviours.add((BlockEntityBehaviour)this.advancementBehaviour);
    }

    public float propagateRotationTo(KineticBlockEntity target, BlockState stateFrom, BlockState stateTo, BlockPos diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        IRotate iRotate;
        Block block;
        Direction direction = KineticsHelper.directionBetween((BlockPos)target.getBlockPos(), (BlockPos)this.getBlockPos());
        if (direction != null && (block = stateTo.getBlock()) instanceof IRotate && (iRotate = (IRotate)block).hasShaftTowards((LevelReader)this.getLevel(), target.getBlockPos(), stateTo, direction)) {
            CoaxialGearBlock.updatePropagationOfLongShaft(stateFrom, (LevelReader)this.level, this.getBlockPos());
        }
        return super.propagateRotationTo(target, stateFrom, stateTo, diff, connectedViaAxes, connectedViaCogs);
    }

    public void tick() {
        super.tick();
        if (this.isVirtual() || !this.hasLevel()) {
            return;
        }
        if (((Boolean)this.getBlockState().getValue((Property)CoaxialGearBlock.HAS_SHAFT)).booleanValue() && !this.getLevel().isClientSide()) {
            Direction.Axis axis = (Direction.Axis)this.getBlockState().getValue((Property)RotatedPillarKineticBlock.AXIS);
            boolean longShaftExists = false;
            for (Direction.AxisDirection axisDirection : Direction.AxisDirection.values()) {
                BlockPos longShaftPos = this.getBlockPos().relative(Direction.get((Direction.AxisDirection)axisDirection, (Direction.Axis)axis));
                BlockState longShaftState = this.getLevel().getBlockState(longShaftPos);
                if (!PetrolsPartsBlocks.LONG_SHAFT.has(longShaftState) || longShaftState.getValue((Property)RotatedPillarKineticBlock.AXIS) != axis || (Boolean)longShaftState.getValue((Property)DirectionalRotatedPillarKineticBlock.POSITIVE_AXIS_DIRECTION) != (axisDirection != Direction.AxisDirection.POSITIVE)) continue;
                longShaftExists = true;
                if (this.speed == 0.0f || this.advancementBehaviour.getPlayer() == null || !this.getLevel().getBlockEntity(longShaftPos, (BlockEntityType)PetrolsPartsBlockEntityTypes.LONG_SHAFT.get()).map(be -> be.getSpeed() != 0.0f && be.getSpeed() != this.speed).orElse(false).booleanValue()) break;
                this.advancementBehaviour.awardAdvancement(PetrolsPartsAdvancementTriggers.COAXIAL_GEAR);
                break;
            }
            if (!longShaftExists) {
                this.getLevel().setBlockAndUpdate(this.getBlockPos(), (BlockState)AllBlocks.SHAFT.getDefaultState().setValue((Property)RotatedPillarKineticBlock.AXIS, (Comparable)axis));
                Block.dropResources((BlockState)this.getBlockState(), (Level)this.level, (BlockPos)this.getBlockPos());
            }
        }
    }
}

