/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.petrolsparts.content.corner_shaft;

import com.petrolpark.petrolsparts.content.corner_shaft.CornerShaftBlockEntity;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.kinetics.base.DirectionalAxisKineticBlock;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class AbstractCornerShaftBlock
extends DirectionalAxisKineticBlock
implements IBE<CornerShaftBlockEntity> {
    public AbstractCornerShaftBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction1 = context.getClickedFace().getOpposite();
        Direction direction2 = direction1.getAxis() == Direction.Axis.Y ? context.getHorizontalDirection() : context.getNearestLookingVerticalDirection();
        return this.getBlockstateConnectingDirections(direction1, direction2);
    }

    public static boolean hasShaftTowards(BlockState state, Direction face) {
        return Arrays.asList(AbstractCornerShaftBlock.getDirectionsConnectedByState(state)).contains(face);
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return AbstractCornerShaftBlock.hasShaftTowards(state, face);
    }

    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        return this.transform(originalState, new StructureTransform(new BlockPos(0, 0, 0), targetedFace.getAxis(), Rotation.CLOCKWISE_90, Mirror.NONE));
    }

    public static Direction[] getDirectionsConnectedByState(BlockState state) {
        Direction facing = (Direction)state.getValue((Property)DirectionalKineticBlock.FACING);
        boolean axisAlongFirst = (Boolean)state.getValue((Property)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE);
        return new Direction[]{facing, Direction.fromAxisAndDirection((Direction.Axis)(switch (facing.getAxis()) {
            case Direction.Axis.X -> axisAlongFirst ? Direction.Axis.Y : Direction.Axis.Z;
            case Direction.Axis.Y -> axisAlongFirst ? Direction.Axis.Z : Direction.Axis.X;
            case Direction.Axis.Z -> axisAlongFirst ? Direction.Axis.X : Direction.Axis.Y;
            default -> throw new IllegalStateException("Unknown axis");
        }), (Direction.AxisDirection)(facing.getAxisDirection() == Direction.AxisDirection.POSITIVE ^ axisAlongFirst ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE))};
    }

    public BlockState getBlockstateConnectingDirections(Direction direction1, Direction direction2) {
        boolean axisAlongFirst = direction1.getAxisDirection() == direction2.getAxisDirection();
        Map<Direction.Axis, Direction> directionsForEachAxis = Map.of(direction1.getAxis(), direction1, direction2.getAxis(), direction2);
        ArrayList<Direction.Axis> axes = new ArrayList<Direction.Axis>();
        axes.addAll(List.of(Direction.Axis.values()));
        axes.remove(direction1.getAxis());
        axes.remove(direction2.getAxis());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)DirectionalKineticBlock.FACING, (Comparable)directionsForEachAxis.get(switch ((Direction.Axis)axes.get(0)) {
            case Direction.Axis.X -> axisAlongFirst ? Direction.Axis.Y : Direction.Axis.Z;
            case Direction.Axis.Y -> axisAlongFirst ? Direction.Axis.Z : Direction.Axis.X;
            case Direction.Axis.Z -> axisAlongFirst ? Direction.Axis.X : Direction.Axis.Y;
            default -> throw new IllegalStateException("Unknown axis");
        }))).setValue((Property)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE, (Comparable)Boolean.valueOf(axisAlongFirst));
    }

    public static boolean isPositiveDirection(Direction direction) {
        return Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)direction.getAxis()) == direction;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        Direction[] directions = AbstractCornerShaftBlock.getDirectionsConnectedByState(state);
        return this.getBlockstateConnectingDirections(rot.rotate(directions[0]), rot.rotate(directions[1]));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        Direction[] directions = AbstractCornerShaftBlock.getDirectionsConnectedByState(state);
        return this.getBlockstateConnectingDirections(mirror.getRotation(directions[0]).rotate(directions[0]), mirror.getRotation(directions[1]).rotate(directions[1]));
    }

    public BlockState transform(BlockState state, StructureTransform transform) {
        Direction[] directions = AbstractCornerShaftBlock.getDirectionsConnectedByState(state);
        return this.getBlockstateConnectingDirections(transform.mirrorFacing(transform.rotateFacing(directions[0])), transform.mirrorFacing(transform.rotateFacing(directions[1])));
    }

    protected boolean areStatesKineticallyEquivalent(BlockState oldState, BlockState newState) {
        return false;
    }

    public Class<CornerShaftBlockEntity> getBlockEntityClass() {
        return CornerShaftBlockEntity.class;
    }
}

