/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.petrolsparts.content.pneumatic_tube;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.petrolpark.compat.create.core.tube.ITubeRenderer;
import com.petrolpark.petrolsparts.PetrolsPartsPartialModels;
import com.petrolpark.petrolsparts.content.pneumatic_tube.PneumaticTubeBlock;
import com.petrolpark.petrolsparts.content.pneumatic_tube.PneumaticTubeBlockEntity;
import com.petrolpark.util.KineticsHelper;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.Optional;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class PneumaticTubeRenderer
extends KineticBlockEntityRenderer<PneumaticTubeBlockEntity>
implements ITubeRenderer<PneumaticTubeBlockEntity> {
    public final PartialModel[] segmentModels = new PartialModel[]{PetrolsPartsPartialModels.PNEUMATIC_TUBE_SEGMENT, PetrolsPartsPartialModels.PNEUMATIC_TUBE_SEGMENT, PetrolsPartsPartialModels.PNEUMATIC_TUBE_SEGMENT_STICHED};
    protected static final int PADDING_SEGMENTS = 2;
    protected static final float BULGE_WIDTH = 8.0f;
    protected static final float BULGE_HEIGHT = 0.15f;

    public PneumaticTubeRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(PneumaticTubeBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        BlockState state = be.getBlockState();
        Direction facing = (Direction)state.getValue((Property)PneumaticTubeBlock.FACING);
        VertexConsumer vc = buffer.getBuffer(RenderType.solid());
        this.renderTube((SmartBlockEntity)be, ms, buffer, light);
        FilteringRenderer.renderOnBlockEntity((SmartBlockEntity)be, (float)partialTicks, (PoseStack)ms, (MultiBufferSource)buffer, (int)light, (int)overlay);
        if (be.isInput() || be.isOutput()) {
            ms.pushPose();
            ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of((PoseStack)ms).center()).rotateToFace(facing.getOpposite())).rotateXDegrees(90.0f)).uncenter();
            SuperByteBuffer arrowBuffer = (SuperByteBuffer)CachedBuffers.partial((PartialModel)PetrolsPartsPartialModels.PNEUMATIC_TUBE_ARROWS, (BlockState)state).translateY(0.21875f);
            if (be.isOutput()) {
                ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)arrowBuffer.translateY(0.0625f)).center()).rotateXDegrees(180.0f)).uncenter();
            }
            arrowBuffer.light(light).renderInto(ms, vc);
            ms.popPose();
        }
        PneumaticTubeRenderer.renderRotatingBuffer((KineticBlockEntity)be, (SuperByteBuffer)this.getRotatedModel(be, state), (PoseStack)ms, (VertexConsumer)buffer.getBuffer(this.getRenderType(be, state)), (int)light);
    }

    public PartialModel[] getTubeSegmentModels(PneumaticTubeBlockEntity be) {
        return this.segmentModels;
    }

    public void modifySegmentScales(PneumaticTubeBlockEntity be, float[] segmentScales, float partialTicks) {
        Optional<PneumaticTubeBlockEntity.Input> inputOp = be.getInput();
        if (inputOp.isEmpty()) {
            return;
        }
        PneumaticTubeBlockEntity.Input input = inputOp.get();
        boolean controllerIsOutput = !be.isInput();
        float pathLength = segmentScales.length + 4;
        for (PneumaticTubeBlockEntity.Input.StackTransporting stackTransporting : input.getStacksTransporting()) {
            float value = stackTransporting.animation.getValue(partialTicks);
            if (controllerIsOutput) {
                value = 1.0f - value;
            }
            int centerSegment = (int)(value * pathLength) - 2;
            for (int segment = centerSegment - 5; segment <= centerSegment + 5 && this.growSegment(segmentScales, segment, this.bulge(((float)(segment + 2) / pathLength - value) * 8.0f) * 0.15f); ++segment) {
            }
        }
    }

    protected boolean growSegment(float[] segmentScales, int index, float scaleBoost) {
        if (index < 0) {
            return true;
        }
        if (index >= segmentScales.length) {
            return false;
        }
        segmentScales[index] = Math.max(segmentScales[index], 1.0f + scaleBoost);
        return true;
    }

    protected float bulge(float x) {
        if (Math.abs(x) > 1.0f) {
            return 0.0f;
        }
        float xx = 1.0f - x * x;
        return xx * xx;
    }

    protected SuperByteBuffer getRotatedModel(PneumaticTubeBlockEntity be, BlockState state) {
        Direction face = (Direction)state.getValue((Property)PneumaticTubeBlock.FACING);
        return CachedBuffers.partialDirectional((PartialModel)AllPartialModels.SHAFTLESS_COGWHEEL, (BlockState)state, (Direction)face, () -> KineticsHelper.rotateToFace((Direction)face.getOpposite()));
    }

    public boolean shouldRenderOffScreen(PneumaticTubeBlockEntity pBlockEntity) {
        return true;
    }
}

