package com.daqem.uilib.api.widget;

import com.daqem.uilib.UILib;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;

public interface IInputValidatable {

    List<class_2561> getInputValidationErrors();

    void setInputValidationErrors(List<class_2561> errors);

    default List<class_2561> validateInput(String input) {
        return new ArrayList<>();
    }

    default boolean hasInputValidationErrors() {
        return !getInputValidationErrors().isEmpty();
    }

    default void clearInputValidationErrors() {
        getInputValidationErrors().clear();
    }

    default List<class_2561> getInputValidationErrorsTooltip() {
        if (hasInputValidationErrors()) {
            List<class_2561> components = new ArrayList<>();
            components.add(UILib.translatable("widget.validation_errors").method_10862(class_2583.field_24360.method_10982(true).method_10977(class_124.field_1061)));
            components.addAll(getInputValidationErrors().stream()
                    .map(x -> class_2561.method_43470("- ").method_10852(x))
                    .toList());
            return components;
        }
        return null;
    }
}
