package com.daqem.uilib.gui;

import com.daqem.uilib.api.background.IBackground;
import com.daqem.uilib.api.component.IComponent;
import com.daqem.uilib.api.screen.IScreen;
import com.daqem.uilib.api.screen.IScreenAccessor;
import com.daqem.uilib.api.widget.IWidget;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;

public class AbstractScreen extends class_437 implements IScreen {

    private @Nullable IBackground background;
    private final IScreenAccessor screenAccessor = this instanceof IScreenAccessor ? (IScreenAccessor) this : null;

    public AbstractScreen(class_2561 title) {
        super(title);
    }

    @Override
    public @NotNull List<? extends class_364> method_25396() {
        List<? extends class_364> widgets = super.method_25396();

        if (screenAccessor != null) {
            List<class_364> combined = new ArrayList<>(widgets);
            for (class_4068 renderable : screenAccessor.uilib$getRenderables()) {
                if (renderable instanceof IComponent component) {
                    combined.addAll(component.getAllWidgets());
                }
            }
            return List.copyOf(combined);
        }

        return widgets;
    }

    @Override
    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.background != null) {
            this.background.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        } else {
            super.method_25420(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    @Override
    public @Nullable IBackground getBackground() {
        return this.background;
    }

    @Override
    public void setBackground(@Nullable IBackground background) {
        this.background = background;
    }

    @Override
    public void clearBackground() {
        this.background = null;
    }

    @Override
    public List<IComponent> getComponents() {
        return screenAccessor != null ? screenAccessor.uilib$getRenderables().stream()
                .filter(renderable -> renderable instanceof IComponent)
                .map(renderable -> (IComponent) renderable)
                .toList() : List.of();
    }

    @Override
    public void addComponent(IComponent component) {
        this.method_37060(component);
    }

    @Override
    public void addComponents(List<? extends IComponent> components) {
        for (IComponent component : components) {
            this.method_37060(component);
        }
    }

    @Override
    public void removeComponent(IComponent component) {
        if (screenAccessor != null) {
            screenAccessor.uilib$getRenderables().remove(component);
        }
    }

    @Override
    public void removeComponents(List<? extends IComponent> components) {
        if (screenAccessor != null) {
            for (IComponent component : components) {
                screenAccessor.uilib$getRenderables().remove(component);
            }
        }
    }

    @Override
    public void clearComponents() {
        if (screenAccessor != null) {
            screenAccessor.uilib$getRenderables().clear();
        }
    }

    @Override
    public List<IWidget> getWidgets() {
        return method_25396().stream()
                .filter(guiEventListener -> guiEventListener instanceof IWidget)
                .map(guiEventListener -> (IWidget) guiEventListener)
                .toList();
    }

    @Override
    public void addWidget(IWidget widget) {
        super.method_37063(widget);
    }

    @Override
    public void addWidgets(List<? extends IWidget> widgets) {
        for (IWidget widget : widgets) {
            this.method_37063(widget);
        }
    }

    @Override
    public void removeWidget(IWidget widget) {
        if (screenAccessor != null) {
            screenAccessor.uilib$removeWidget(widget);
        }
    }

    @Override
    public void removeWidgets(List<? extends IWidget> widgets) {
        if (screenAccessor != null) {
            for (IWidget widget : widgets) {
                screenAccessor.uilib$removeWidget(widget);
            }
        }
    }

    @Override
    public void clearOnlyWidgets() {
        if (screenAccessor != null) {
            screenAccessor.uilib$getRenderables().removeIf(renderable -> renderable instanceof IWidget);
            screenAccessor.uilib$getChildren().removeIf(renderable -> renderable instanceof IWidget);
            screenAccessor.uilib$getNarratables().removeIf(renderable -> renderable instanceof IWidget);
        }
    }

    @Override
    public void clear() {
        if (screenAccessor != null) {
            screenAccessor.uilib$getRenderables().clear();
            screenAccessor.uilib$getChildren().clear();
            screenAccessor.uilib$getNarratables().clear();
        }
    }

    @Override
    protected void method_25426() {
        super.method_25426();

        if (screenAccessor != null) {
            for (class_4068 uilib$getRenderable : screenAccessor.uilib$getRenderables()) {
                if (uilib$getRenderable instanceof IComponent component) {
                    component.updateParentPosition(0, 0, this.field_22789, this.field_22790);
                }
                if (uilib$getRenderable instanceof IWidget widget) {
                    widget.uilib$updateParentPosition(0, 0);
                }
            }
        }
    }
}
