package com.daqem.uilib.gui.component.text;

import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3532;

public class ScrollingTextComponent extends AbstractSingleLineTextComponent {

    private int maxWidth;

    public ScrollingTextComponent(int x, int y, int maxWidth, class_2561 text) {
        super(x, y, text);
        this.maxWidth = maxWidth;
    }

    public ScrollingTextComponent(int x, int y, int maxWidth, class_2561 text, int color) {
        super(x, y, text, color);
        this.maxWidth = maxWidth;
    }

    @Override
    public void render(class_332 guiGraphics, int mouseX, int mouseY, float partialTick, int parentWidth, int parentHeight) {
        if (method_25368() > maxWidth) {
            guiGraphics.method_44379(
                    getTotalX() + getXOffset(),
                    getTotalY(),
                    getTotalX() + maxWidth + getXOffset(),
                    getTotalY() + method_25364()
            );
            int hiddenWidth = method_25368() - maxWidth;
            double currentTimeSeconds = class_156.method_658() / 1000.0;
            double animationDuration = Math.max(hiddenWidth * 0.5, 3.0);
            double animationFactor = Math.sin((Math.PI / 2) * Math.cos((Math.PI * 2) * currentTimeSeconds / animationDuration)) / 2.0 + 0.5;
            double scrollOffset = class_3532.method_16436(animationFactor, 0.0, hiddenWidth);
            drawText(guiGraphics, (int) scrollOffset - getXOffset());
            guiGraphics.method_44380();
        } else {
            drawText(guiGraphics, 0);
        }

        if (isRenderDebugBorder()) {
            guiGraphics.method_51738(getTotalX() + getXOffset(), getTotalX() + maxWidth + getXOffset() - 1, getTotalY(), 0xFF0000FF);
            guiGraphics.method_51742(getTotalX() + maxWidth + getXOffset() - 1, getTotalY(), getTotalY() + method_25364() - 1, 0xFF0000FF);
            guiGraphics.method_51738(getTotalX() + getXOffset(), getTotalX() + maxWidth + getXOffset() - 1, getTotalY() + method_25364() - 1, 0xFF0000FF);
            guiGraphics.method_51742(getTotalX() + getXOffset(), getTotalY(), getTotalY() + method_25364() - 1, 0xFF0000FF);
        }
    }

    protected int getXOffset() {
        switch (getTextAlign()) {
            case CENTER -> {
                return (method_25368() - maxWidth) / 2;
            }
            case RIGHT -> {
                return method_25368() - maxWidth;
            }
            default -> {
                return 0;
            }
        }
    }

    public int getMaxWidth() {
        return maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    private void drawText(class_332 guiGraphics, int scrollOffset) {
        guiGraphics.method_51439(
                this.getFont(),
                this.getText(),
                this.getTotalX() - scrollOffset,
                this.getTotalY(),
                this.getColor(),
                this.isDrawShadow()
        );
    }
}
