package com.daqem.uilib.gui.widget;

import com.daqem.uilib.UILib;
import com.daqem.uilib.api.widget.IEditBoxWidget;
import com.daqem.uilib.api.widget.IInputValidatable;
import com.daqem.uilib.api.widget.IWidget;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_7999;
import net.minecraft.class_8000;
import net.minecraft.class_8030;
import net.minecraft.class_8092;

public class EditBoxWidget extends class_342 implements IWidget, IInputValidatable {

    private List<class_2561> inputValidationErrors = new ArrayList<>();

    public EditBoxWidget(class_327 font, int width, int height, class_2561 title) {
        super(font, width, height, title);
    }

    public EditBoxWidget(class_327 font, int x, int y, int width, int height, class_2561 title) {
        super(font, x, y, width, height, title);
    }

    public EditBoxWidget(class_327 font, int x, int y, int width, int height, @Nullable class_342 editBox, class_2561 title) {
        super(font, x, y, width, height, editBox, title);
    }

    @Override
    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        // Had to add this because the text position wasn't updating correctly when set with an initial value
        if (this instanceof IEditBoxWidget editBoxWidget) {
            editBoxWidget.uilib$updateTextPosition();
        }

        List<class_2561> components = this.validateInput(method_1882());
        if (components != null && !components.isEmpty()) {
            setInputValidationErrors(components);
        } else {
            clearInputValidationErrors();
        }

        super.method_48579(guiGraphics, mouseX, mouseY, partialTick);

        List<class_2561> tooltip = getInputValidationErrorsTooltip();
        class_310 minecraft = class_310.method_1551();
        if (tooltip != null && (method_49606() || method_25370() && minecraft.method_48186().method_48183())) {
            guiGraphics.method_51436(
                    minecraft.field_1772,
                    class_2477.method_10517().method_30933(new ArrayList<>(tooltip)),
                    this.createTooltipPositioner(method_48202(), method_49606(), method_25370()),
                    mouseX,
                    mouseY,
                    method_25370()
            );
        }
    }

    @Override
    public List<class_2561> getInputValidationErrors() {
        if (this.inputValidationErrors == null) {
            this.inputValidationErrors = new ArrayList<>();
        }
        return this.inputValidationErrors;
    }

    @Override
    public void setInputValidationErrors(List<class_2561> errors) {
        if (errors == null) {
            errors = new ArrayList<>();
        }
        this.inputValidationErrors = errors;
    }

    private class_8000 createTooltipPositioner(class_8030 screenRectangle, boolean hovering, boolean focused) {
        return !hovering && focused && class_310.method_1551().method_48186().method_48183()
                ? new class_7999(screenRectangle)
                : new class_8092(screenRectangle);
    }
}
