package com.daqem.uilib.gui.widget;

import com.daqem.uilib.api.IParent;
import com.daqem.uilib.api.component.IComponent;
import com.daqem.uilib.api.widget.IWidget;
import com.daqem.uilib.mixin.AbstractScrollAreaAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_10799;
import net.minecraft.class_11876;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_8028;
import net.minecraft.class_8030;
import net.minecraft.class_9017;

public class ScrollContainer2DWidget extends class_9017 implements IWidget, IParent {

    private static final class_2960 SCROLLER_SPRITE = class_2960.method_60656("widget/scroller");
    private static final class_2960 SCROLLER_BACKGROUND_SPRITE = class_2960.method_60656("widget/scroller_background");

    protected final List<IComponent> components = new ArrayList<>();
    private final int contentSpacing;
    private double horizontalScrollAmount;
    private boolean scrollingHorizontal;
    private boolean scrollingVertical;

    public ScrollContainer2DWidget(int width, int height, int contentSpacing) {
        super(0, 0, width, height, class_2561.method_43473());
        this.contentSpacing = contentSpacing;
        this.horizontalScrollAmount = 0.0;
    }

    public ScrollContainer2DWidget(int width, int height) {
        this(width, height, 0);
    }

    @Override
    protected int method_44395() {
        if (components.isEmpty()) {
            return 0;
        }
        return this.components.stream()
                .mapToInt(IComponent::method_25364)
                .sum() + (getContentSpacing() * (this.components.size() - 1));
    }

    @Override
    protected double method_44393() {
        return 10;
    }

    protected int contentWidth() {
        if (components.isEmpty()) {
            return 0;
        }
        return this.components.stream()
                .mapToInt(IComponent::method_25368)
                .max()
                .orElse(0);
    }

    protected int maxHorizontalScrollAmount() {
        return Math.max(0, this.contentWidth() - this.field_22758);
    }

    protected boolean horizontalScrollbarVisible() {
        return this.maxHorizontalScrollAmount() > 0;
    }

    protected int scrollerWidth() {
        int adjW = this.field_22758 - (this.method_44392() ? 6 : 0);
        int contentW = this.contentWidth();
        if (contentW <= adjW) {
            return 0;
        }
        return class_3532.method_15340((int) ((float) (adjW * adjW) / contentW), 32, adjW - 8);
    }

    protected double horizontalScrollRate() {
        return 10.0;
    }

    public double horizontalScrollAmount() {
        return this.horizontalScrollAmount;
    }

    public void setHorizontalScrollAmount(double amount) {
        this.horizontalScrollAmount = class_3532.method_15350(amount, 0.0, this.maxHorizontalScrollAmount());
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (!this.field_22764) {
            return false;
        }
        boolean handled = false;
        if (scrollY != 0.0) {
            this.method_44382(this.method_44387() - scrollY * this.method_44393());
            handled = true;
        }
        if (scrollX != 0.0) {
            this.setHorizontalScrollAmount(this.horizontalScrollAmount() - scrollX * this.horizontalScrollRate());
            handled = true;
        }
        return handled;
    }

    @Override
    public boolean method_25402(class_11909 event, boolean bl) {
        if (!this.field_22763 || !this.field_22764) {
            return false;
        }
        boolean handled = false;
        if (this.method_25351(event.comp_4800())) {
            boolean onHBar = this.horizontalScrollbarVisible() &&
                    event.comp_4799() >= this.method_55443() - 6 &&
                    event.comp_4799() < this.method_55443() &&
                    event.comp_4798() >= this.method_46426() &&
                    event.comp_4798() < this.method_55442();
            this.scrollingHorizontal = onHBar;

            boolean onVBar = !onHBar && this.method_44392() &&
                    event.comp_4798() >= this.method_65507() &&
                    event.comp_4798() < this.method_65507() + 6 &&
                    event.comp_4799() >= this.method_46427() &&
                    event.comp_4799() < this.method_55443();
            this.scrollingVertical = onVBar;

            if (onHBar || onVBar) {
                handled = true;
            } else {
                Optional<class_364> optional = this.method_19355(event.comp_4798(), event.comp_4799());
                if (optional.isPresent()) {
                    class_364 guiEventListener = optional.get();
                    if (guiEventListener.method_25402(event, bl)) {
                        this.method_25395(guiEventListener);
                        if (event.method_74245() == 0) {
                            this.method_25398(true);
                        }
                        handled = true;
                    }
                } else {
                    this.method_25348(event, bl);
                    handled = true;
                }
            }
        }
        return handled;
    }

    @Override
    public boolean method_25403(class_11909 event, double dragX, double dragY) {
        if (this.scrollingVertical) {
            if (event.comp_4799() < this.method_46427()) {
                this.method_44382(0.0);
            } else if (event.comp_4799() > this.method_55443()) {
                this.method_44382(this.method_44390());
            } else {
                double d = Math.max(1, this.method_44390());
                int i = this.method_44394();
                double e = Math.max(1.0, d / (this.field_22759 - i));
                this.method_44382(this.method_44387() + dragY * e);
            }
            return true;
        } else if (this.scrollingHorizontal) {
            if (event.comp_4798() < this.method_46426()) {
                this.setHorizontalScrollAmount(0.0);
            } else if (event.comp_4798() > this.method_55442()) {
                this.setHorizontalScrollAmount(this.maxHorizontalScrollAmount());
            } else {
                double d = Math.max(1, this.maxHorizontalScrollAmount());
                int i = this.scrollerWidth();
                double e = Math.max(1.0, d / (this.field_22758 - i));
                this.setHorizontalScrollAmount(this.horizontalScrollAmount() + dragX * e);
            }
            return true;
        } else {
            return super.method_25403(event, dragX, dragY);
        }
    }

    @Override
    public void method_25357(class_11909 mouseButtonEvent) {
        this.scrollingVertical = false;
        this.scrollingHorizontal = false;
    }

    @Override
    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        boolean vBar = this.method_44392();
        boolean hBar = this.horizontalScrollbarVisible();
        int availW = this.field_22758 - (vBar ? 6 : 0);
        int availH = this.field_22759 - (hBar ? 6 : 0);
        guiGraphics.method_44379(this.method_46426(), this.method_46427(), this.method_46426() + availW, this.method_46427() + availH);

        int currentX = this.uilib$getParentX() - this.method_46426() - (int) this.horizontalScrollAmount();
        int currentY = this.uilib$getParentY() - this.method_46427() - (int) this.method_44387();
        for (int i = 0; i < this.components.size(); i++) {
            IComponent component = this.components.get(i);
            component.method_46421(currentX);
            component.method_46419(currentY);
            component.renderBase(guiGraphics, mouseX, mouseY, partialTick, availW, availH);
            currentY += component.method_25364();
            if (i < this.components.size() - 1) {
                currentY += getContentSpacing();
            }
        }

        guiGraphics.method_44380();
        this.method_44396(guiGraphics, mouseX, mouseY);
    }

    @Override
    protected void method_44396(class_332 guiGraphics, int mouseX, int mouseY) {
        // Vertical scrollbar
        if (this.method_44392()) {
            int adjH = this.field_22759 - (this.horizontalScrollbarVisible() ? 6 : 0);
            int scrollBarX = this.method_65507();
            int scrollerHeight = this.method_44394();
            int scrollBarY = this.method_65508();
            guiGraphics.method_52706(class_10799.field_56883, SCROLLER_BACKGROUND_SPRITE, scrollBarX, this.method_46427(), 6, adjH);
            guiGraphics.method_52706(class_10799.field_56883, SCROLLER_SPRITE, scrollBarX, scrollBarY, 6, scrollerHeight);
            if (this.method_74038(mouseX, mouseY)) {
                guiGraphics.method_74037(((AbstractScrollAreaAccessor) this).uilib$isScrolling() ? class_11876.field_62456 : class_11876.field_62455);
            }
        }

        // Horizontal scrollbar
        if (this.horizontalScrollbarVisible()) {
            int adjW = this.field_22758 - (this.method_44392() ? 6 : 0);
            int bottom = this.method_55443();
            int hY = bottom - 6;
            int hX = this.method_46426();
            guiGraphics.method_52706(class_10799.field_56883, SCROLLER_BACKGROUND_SPRITE, hX, hY, adjW, 6);
            int scrollerW = this.scrollerWidth();
            double fracH = this.maxHorizontalScrollAmount() > 0 ? this.horizontalScrollAmount() / this.maxHorizontalScrollAmount() : 0.0;
            int scrollerX = (int) (hX + fracH * (adjW - scrollerW));
            guiGraphics.method_52706(class_10799.field_56883, SCROLLER_SPRITE, scrollerX, hY, scrollerW, 6);
            if (this.method_74038(mouseX, mouseY)) {
                guiGraphics.method_74037(((AbstractScrollAreaAccessor) this).uilib$isScrolling() ? class_11876.field_62456 : class_11876.field_62455);
            }
        }
    }

    @Override
    protected boolean method_74038(double d, double e) {
        boolean overVBar = this.method_44392() &&
                d >= this.method_65507() &&
                d < this.method_65507() + 6 &&
                e >= this.method_46427() &&
                e < this.method_55443();
        boolean overHBar = this.horizontalScrollbarVisible() &&
                e >= this.method_55443() - 6 &&
                e < this.method_55443() &&
                d >= this.method_46426() &&
                d < this.method_55442();
        return overVBar || overHBar;
    }

    @Override
    protected int method_44394() {
        int adjH = this.field_22759 - (this.horizontalScrollbarVisible() ? 6 : 0);
        int contentH = this.method_44395();
        if (contentH <= adjH) {
            return 0;
        }
        return class_3532.method_15340((int) ((float) (adjH * adjH) / contentH), 32, adjH - 8);
    }

    @Override
    protected int method_65508() {
        int max = this.method_44390();
        if (max == 0) {
            return this.method_46427();
        }
        int adjH = this.field_22759 - (this.horizontalScrollbarVisible() ? 6 : 0);
        int h = this.method_44394();
        return (int) (this.method_44387() * (adjH - h) / max) + this.method_46427();
    }

    @Override
    protected void method_47399(class_6382 narrationElementOutput) {
    }

    @Override
    public @NotNull class_8030 method_65515(class_8028 direction) {
        return new class_8030(this.method_46426(), this.method_46427(), this.field_22758, this.method_44395());
    }

    @Override
    public void method_25395(@Nullable class_364 focused) {
        super.method_25395(focused);
        if (focused != null && class_310.method_1551().method_48186().method_48183()) {
            class_8030 screenRectangle = this.method_48202();
            class_8030 screenRectangle2 = focused.method_48202();
            int i = screenRectangle2.method_49618() - screenRectangle.method_49618();
            int j = screenRectangle2.method_49619() - screenRectangle.method_49619();
            if (i < 0) {
                this.method_44382(this.method_44387() + i - 14.0);
            } else if (j > 0) {
                this.method_44382(this.method_44387() + j + 14.0);
            }
        }
    }

    @Override
    public @NotNull List<? extends class_364> method_25396() {
        return getWidgets();
    }

    @Override
    public @NotNull Collection<? extends class_6379> method_65516() {
        return getWidgets();
    }

    @Override
    public List<IComponent> getComponents() {
        return this.components;
    }

    @Override
    public void addComponent(IComponent component) {
        this.components.add(component);
    }

    @Override
    public void addComponents(List<? extends IComponent> components) {
        this.components.addAll(components);
    }

    @Override
    public void removeComponent(IComponent component) {
        this.components.remove(component);
    }

    @Override
    public void removeComponents(List<? extends IComponent> components) {
        this.components.removeAll(components);
    }

    @Override
    public void clearComponents() {
        this.components.clear();
    }

    @Override
    public void clear() {
        clearComponents();
        clearOnlyWidgets();
    }

    @Override
    public List<IWidget> getWidgets() {
        return this.components.stream()
                .flatMap(component -> component.getAllWidgets().stream())
                .toList();
    }

    @Override
    public void addWidget(IWidget widget) {
        throw new UnsupportedOperationException("Cannot add a widget directly to ScrollContainer2DWidget. Add it to a component instead.");
    }

    @Override
    public void addWidgets(List<? extends IWidget> widgets) {
        throw new UnsupportedOperationException("Cannot add widgets directly to ScrollContainer2DWidget. Add them to a component instead.");
    }

    @Override
    public void removeWidget(IWidget widget) {
        throw new UnsupportedOperationException("Cannot remove a widget directly from ScrollContainer2DWidget. Remove it from a component instead.");
    }

    @Override
    public void removeWidgets(List<? extends IWidget> widgets) {
        throw new UnsupportedOperationException("Cannot remove widgets directly from ScrollContainer2DWidget. Remove them from a component instead.");
    }

    @Override
    public void clearOnlyWidgets() {
        throw new UnsupportedOperationException("Cannot clear widgets directly from ScrollContainer2DWidget. Clear them from components instead.");
    }

    public int getContentSpacing() {
        return contentSpacing;
    }
}