package com.daqem.uilib.test.component;

import com.daqem.uilib.UILib;
import com.daqem.uilib.gui.component.AbstractComponent;
import com.daqem.uilib.gui.widget.*;
import com.daqem.uilib.test.TestScreen;
import com.daqem.uilib.test.component.sprite.TestSpriteComponent;
import com.daqem.uilib.util.ValidationErrors;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5676;
import net.minecraft.class_7919;


public class TestWidgetsComponent extends AbstractComponent {

    public TestWidgetsComponent(int number) {
        super(0, 0, 200, 150);

        class_2561 text = UILib.translatable("component.test.number", number);

        TestSpriteComponent spriteComponent = new TestSpriteComponent(-10, -10, 220, 170);

        ButtonWidget button = new ButtonWidget(0, 0, 200, 20, text, button1 -> {
            if (class_310.method_1551().field_1755 instanceof TestScreen screen) {
                screen.method_25419();
            }
        });
        button.method_47400(class_7919.method_47407(text));

        List<String> values = List.of("test", "testen");
        EditBoxWidget editBox = new EditBoxWidget(class_310.method_1551().field_1772, 0, 22, 200, 20, class_2561.method_43470("test")) {
            @Override
            public List<class_2561> validateInput(String input) {
                List<class_2561> list = super.validateInput(input);
                if (input.length() < 6) {
                    list.add(ValidationErrors.minLength(6));
                }
                if (!values.contains(input)) {
                    list.add(ValidationErrors.validValues(values));
                }
                return list;
            }
        };
        editBox.method_1852("This is a test!");
        editBox.method_1880(128);

        MultiLineEditBoxWidget multiLineEditBox = new MultiLineEditBoxWidget(class_310.method_1551().field_1772, 0, 44, 200, 60, text, class_2561.method_43470("test")) {
            @Override
            public List<class_2561> validateInput(String input) {
                List<class_2561> list = super.validateInput(input);
                if (input.length() < 6) {
                    list.add(ValidationErrors.minLength(6));
                }
                if (!values.contains(input)) {
                    list.add(ValidationErrors.validValues(values));
                }
                return list;
            }
        };
        multiLineEditBox.method_44400("This is a test!\nWith multiple lines!\nLine 3\nLine 4\nLine 5\nLine 6\nLine 7\nLine 8\nLine 9\nLine 10");

        CycleButtonWidget<Boolean> cycleButton = new CycleButtonWidget<>(0, 106, 200, 20, text, 0, true, class_5676.class_5680.method_32627(List.of(true, false)), value -> value ? UILib.translatable("component.test.true") : UILib.translatable("component.test.false"));
        cycleButton.method_47400(class_7919.method_47407(text));

        this.addComponent(spriteComponent);
        this.addWidget(button);
        this.addWidget(editBox);
        this.addWidget(multiLineEditBox);
        this.addWidget(cycleButton);
    }

    @Override
    public void render(class_332 guiGraphics, int mouseX, int mouseY, float partialTick, int parentWidth, int parentHeight) {
    }
}
