/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.uilib.gui.component.text;

import com.daqem.uilib.gui.component.text.AbstractSingleLineTextComponent;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3532;

public class ScrollingTextComponent
extends AbstractSingleLineTextComponent {
    private int maxWidth;

    public ScrollingTextComponent(int x, int y, int maxWidth, class_2561 text) {
        super(x, y, text);
        this.maxWidth = maxWidth;
    }

    public ScrollingTextComponent(int x, int y, int maxWidth, class_2561 text, int color) {
        super(x, y, text, color);
        this.maxWidth = maxWidth;
    }

    @Override
    public void render(class_332 guiGraphics, int mouseX, int mouseY, float partialTick, int parentWidth, int parentHeight) {
        if (this.method_25368() > this.maxWidth) {
            guiGraphics.method_44379(this.getTotalX() + this.getXOffset(), this.getTotalY(), this.getTotalX() + this.maxWidth + this.getXOffset(), this.getTotalY() + this.method_25364());
            int hiddenWidth = this.method_25368() - this.maxWidth;
            double currentTimeSeconds = (double)class_156.method_658() / 1000.0;
            double animationDuration = Math.max((double)hiddenWidth * 0.5, 3.0);
            double animationFactor = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * currentTimeSeconds / animationDuration)) / 2.0 + 0.5;
            double scrollOffset = class_3532.method_16436((double)animationFactor, (double)0.0, (double)hiddenWidth);
            this.drawText(guiGraphics, (int)scrollOffset - this.getXOffset());
            guiGraphics.method_44380();
        } else {
            this.drawText(guiGraphics, 0);
        }
        if (this.isRenderDebugBorder()) {
            guiGraphics.method_51738(this.getTotalX() + this.getXOffset(), this.getTotalX() + this.maxWidth + this.getXOffset() - 1, this.getTotalY(), -16776961);
            guiGraphics.method_51742(this.getTotalX() + this.maxWidth + this.getXOffset() - 1, this.getTotalY(), this.getTotalY() + this.method_25364() - 1, -16776961);
            guiGraphics.method_51738(this.getTotalX() + this.getXOffset(), this.getTotalX() + this.maxWidth + this.getXOffset() - 1, this.getTotalY() + this.method_25364() - 1, -16776961);
            guiGraphics.method_51742(this.getTotalX() + this.getXOffset(), this.getTotalY(), this.getTotalY() + this.method_25364() - 1, -16776961);
        }
    }

    protected int getXOffset() {
        switch (this.getTextAlign()) {
            case CENTER: {
                return (this.method_25368() - this.maxWidth) / 2;
            }
            case RIGHT: {
                return this.method_25368() - this.maxWidth;
            }
        }
        return 0;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    private void drawText(class_332 guiGraphics, int scrollOffset) {
        guiGraphics.method_51439(this.getFont(), this.getText(), this.getTotalX() - scrollOffset, this.getTotalY(), this.getColor(), this.isDrawShadow());
    }
}

