/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.uilib.gui.component.text;

import com.daqem.uilib.gui.component.text.AbstractSingleLineTextComponent;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class TruncatedTextComponent
extends AbstractSingleLineTextComponent {
    private int maxWidth;
    private String ellipsis = "...";
    private class_2561 backupText;

    public TruncatedTextComponent(int x, int y, int maxWidth, class_2561 text) {
        super(x, y, text);
        this.maxWidth = maxWidth;
        this.backupText = text;
        this.setTruncatedText();
    }

    public TruncatedTextComponent(int x, int y, int maxWidth, class_2561 text, int color) {
        super(x, y, text, color);
        this.maxWidth = maxWidth;
        this.backupText = text;
        this.setTruncatedText();
    }

    @Override
    public void render(class_332 guiGraphics, int mouseX, int mouseY, float partialTick, int parentWidth, int parentHeight) {
        guiGraphics.method_51439(this.getFont(), this.getText(), this.getTotalX(), this.getTotalY(), this.getColor(), this.isDrawShadow());
        if (this.isRenderDebugBorder()) {
            guiGraphics.method_51738(this.getTotalX() + this.getUnusedSpaceX(), this.getTotalX() + this.maxWidth + this.getUnusedSpaceX() - 1, this.getTotalY(), -16776961);
            guiGraphics.method_51742(this.getTotalX() + this.maxWidth + this.getUnusedSpaceX() - 1, this.getTotalY(), this.getTotalY() + this.method_25364() - 1, -16776961);
            guiGraphics.method_51738(this.getTotalX() + this.getUnusedSpaceX(), this.getTotalX() + this.maxWidth + this.getUnusedSpaceX() - 1, this.getTotalY() + this.method_25364() - 1, -16776961);
            guiGraphics.method_51742(this.getTotalX() + this.getUnusedSpaceX(), this.getTotalY(), this.getTotalY() + this.method_25364() - 1, -16776961);
        }
    }

    protected int getUnusedSpaceX() {
        switch (this.getTextAlign()) {
            case CENTER: {
                return (this.method_25368() - this.maxWidth) / 2;
            }
            case RIGHT: {
                return this.method_25368() - this.maxWidth;
            }
        }
        return 0;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        this.setTruncatedText();
    }

    public String getEllipsis() {
        return this.ellipsis;
    }

    public void setEllipsis(String ellipsis) {
        this.ellipsis = ellipsis;
        this.setTruncatedText();
    }

    private void setTruncatedText() {
        String text = this.backupText.getString();
        class_327 font = this.getFont();
        if (font.method_1727(text) <= this.maxWidth) {
            this.setText(this.backupText);
            return;
        }
        int ellipsisWidth = font.method_1727(this.getEllipsis());
        int availableWidth = this.maxWidth - ellipsisWidth;
        StringBuilder truncated = new StringBuilder();
        for (char c : text.toCharArray()) {
            if (font.method_1727(truncated.toString() + c) > availableWidth) break;
            truncated.append(c);
        }
        truncated.append(this.getEllipsis());
        this.setText((class_2561)class_2561.method_43470((String)truncated.toString()).method_10862(this.getText().method_10866()));
    }
}

