package com.daqem.uilib.gui.component.text;

import com.daqem.uilib.gui.component.AbstractComponent;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;

public abstract class AbstractTextComponent extends AbstractComponent {

    private class_2561 text;
    private int color;
    private boolean drawShadow = false;
    private TextAlign textAlign = TextAlign.LEFT;
    private class_327 font = class_310.method_1551().field_1772;

    public AbstractTextComponent(int x, int y, int width, int height, class_2561 text) {
        this(x, y, width, height, text, 0xFFFFFFFF);
    }

    public AbstractTextComponent(int x, int y, int width, int height, class_2561 text, int color) {
        super(x, y, width, height);
        this.text = text;
        this.color = color;
    }

    @Override
    public int getTotalX() {
        switch (getTextAlign()) {
            case CENTER -> {
                return super.getTotalX() - (method_25368() / 2);
            }
            case RIGHT -> {
                return super.getTotalX() - method_25368();
            }
            case LEFT -> {
                return super.getTotalX();
            }
        }
        return super.getTotalX();
    }

    public class_2561 getText() {
        return text;
    }

    public void setText(class_2561 text) {
        this.text = text;
    }

    public int getColor() {
        return color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public boolean isDrawShadow() {
        return drawShadow;
    }

    public void setDrawShadow(boolean drawShadow) {
        this.drawShadow = drawShadow;
    }

    public TextAlign getTextAlign() {
        return textAlign;
    }

    public void setTextAlign(TextAlign textAlign) {
        this.textAlign = textAlign;
    }

    public class_327 getFont() {
        return font;
    }

    public void setFont(class_327 font) {
        this.font = font;
    }
}
