package com.daqem.uilib.gui.component.text;

import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class TruncatedTextComponent extends AbstractSingleLineTextComponent{

    private int maxWidth;
    private String ellipsis = "...";

    private class_2561 backupText;

    public TruncatedTextComponent(int x, int y, int maxWidth, class_2561 text) {
        super(x, y, text);
        this.maxWidth = maxWidth;
        this.backupText = text;
        setTruncatedText();
    }

    public TruncatedTextComponent(int x, int y, int maxWidth, class_2561 text, int color) {
        super(x, y, text, color);
        this.maxWidth = maxWidth;
        this.backupText = text;
        setTruncatedText();
    }

    @Override
    public void render(class_332 guiGraphics, int mouseX, int mouseY, float partialTick, int parentWidth, int parentHeight) {
        guiGraphics.method_51439(
                this.getFont(),
                this.getText(),
                this.getTotalX(),
                this.getTotalY(),
                this.getColor(),
                this.isDrawShadow()
        );

        if (isRenderDebugBorder()) {
            guiGraphics.method_51738(getTotalX() + getUnusedSpaceX(), getTotalX() + maxWidth + getUnusedSpaceX() - 1, getTotalY(), 0xFF0000FF);
            guiGraphics.method_51742(getTotalX() + maxWidth + getUnusedSpaceX() - 1, getTotalY(), getTotalY() + method_25364() - 1, 0xFF0000FF);
            guiGraphics.method_51738(getTotalX() + getUnusedSpaceX(), getTotalX() + maxWidth + getUnusedSpaceX() - 1, getTotalY() + method_25364() - 1, 0xFF0000FF);
            guiGraphics.method_51742(getTotalX() + getUnusedSpaceX(), getTotalY(), getTotalY() + method_25364() - 1, 0xFF0000FF);
        }
    }

    protected int getUnusedSpaceX() {
        switch (getTextAlign()) {
            case CENTER -> {
                return (method_25368() - maxWidth) / 2;
            }
            case RIGHT -> {
                return method_25368() - maxWidth;
            }
            default -> {
                return 0;
            }
        }
    }

    public int getMaxWidth() {
        return maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        setTruncatedText();
    }

    public String getEllipsis() {
        return ellipsis;
    }

    public void setEllipsis(String ellipsis) {
        this.ellipsis = ellipsis;
        setTruncatedText();
    }

    private void setTruncatedText() {
        String text = backupText.getString();
        class_327 font = getFont();
        if (font.method_1727(text) <= maxWidth) {
            setText(backupText);
            return;
        }
        int ellipsisWidth = font.method_1727(getEllipsis());
        int availableWidth = maxWidth - ellipsisWidth;
        StringBuilder truncated = new StringBuilder();
        for (char c : text.toCharArray()) {
            if (font.method_1727(truncated.toString() + c) > availableWidth) {
                break;
            }
            truncated.append(c);
        }
        truncated.append(getEllipsis());
        setText(class_2561.method_43470(truncated.toString()).method_10862(this.getText().method_10866()));
    }
}
