package com.daqem.uilib.gui.component.text.multiline;

import com.daqem.uilib.gui.component.text.AbstractTextComponent;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_5225;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public abstract class AbstractMultiLineTextComponent extends AbstractTextComponent {

    private int maxWidth;
    private List<class_5481> lines;

    public AbstractMultiLineTextComponent(int x, int y, int maxWidth, class_2561 text) {
        super(x, y, 0, 0, text);
        this.maxWidth = maxWidth;
        updateSize();
    }

    public AbstractMultiLineTextComponent(int x, int y, int maxWidth, class_2561 text, int color) {
        super(x, y, 0, 0, text, color);
        this.maxWidth = maxWidth;
        updateSize();
    }

    public AbstractMultiLineTextComponent(int x, int y, int maxWidth, class_2561 text, boolean preformSizeUpdate) {
        super(x, y, 0, 0, text);
        this.maxWidth = maxWidth;
        if (preformSizeUpdate) updateSize();
    }

    public AbstractMultiLineTextComponent(int x, int y, int maxWidth, class_2561 text, int color, boolean preformSizeUpdate) {
        super(x, y, 0, 0, text, color);
        this.maxWidth = maxWidth;
        if (preformSizeUpdate) updateSize();
    }

    public List<class_5481> getLines() {
        return lines;
    }

    public void setLines(List<class_5481> lines) {
        this.lines = lines;
    }

    public int getMaxWidth() {
        return maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        updateSize();
    }

    protected void updateSize() {
        this.lines = class_2477.method_10517().method_30933(findOptimalLines(getFont(), getText(), maxWidth));
        setWidth(lines.stream().mapToInt(getFont()::method_30880).max().orElse(0));
        setHeight(getFont().field_2000 * getLines().size());
    }

    protected int getUnusedSpaceX() {
        switch (getTextAlign()) {
            case CENTER -> {
                return (method_25368() - getMaxWidth()) / 2;
            }
            case RIGHT -> {
                return method_25368() - getMaxWidth();
            }
            default -> {
                return 0;
            }
        }
    }

    protected static List<class_5348> findOptimalLines(class_327 font, class_2561 component, int width) {
        class_5225 stringSplitter = font.method_27527();
        List<class_5348> optimalLines = null;
        float minDifference = Float.MAX_VALUE;
        float tolerance = 10.0F;
        int offset = 0;

        List<class_5348> lines = stringSplitter.method_27495(component, width - offset, class_2583.field_24360);
        float difference = Math.abs(getMaxWidth(stringSplitter, lines) - (float) width);
        if (difference <= tolerance) {
            return lines;
        }

        if (difference < minDifference) {
            optimalLines = lines;
        }

        return optimalLines;
    }


    private static float getMaxWidth(@NotNull class_5225 stringSplitter, List<class_5348> formattedTexts) {
        return (float) formattedTexts.stream().mapToDouble(stringSplitter::method_27488).max().orElse(0.0F);
    }
}
