package com.daqem.uilib.gui.component.text.multiline;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_332;
import net.minecraft.class_5481;

public class TruncatedMultiLineTextComponent extends AbstractMultiLineTextComponent{

    private int maxLines;
    private String ellipsis = "...";

    public TruncatedMultiLineTextComponent(int x, int y, int maxWidth, int maxLines, class_2561 text) {
        super(x, y, maxWidth, text, false);
        this.maxLines = maxLines;
        updateSize();
    }

    public TruncatedMultiLineTextComponent(int x, int y, int maxWidth, int maxLines, class_2561 text, int color) {
        super(x, y, maxWidth, text, color, false);
        this.maxLines = maxLines;
        updateSize();
    }

    public int getMaxLines() {
        return maxLines;
    }

    public void setMaxLines(int maxLines) {
        this.maxLines = maxLines;
    }

    public String getEllipsis() {
        return ellipsis;
    }

    public void setEllipsis(String ellipsis) {
        this.ellipsis = ellipsis;
    }

    @Override
    protected void updateSize() {
        setLines(class_2477.method_10517().method_30933(findOptimalLines(getFont(), getText(), getMaxWidth())));
        if (getLines().size() > maxLines) {
            List<class_5481> lines = new ArrayList<>(getLines());
            lines.subList(maxLines, lines.size()).clear();
            setLines(lines);
            int lastIndex = getLines().size() - 1;
            if (lastIndex < 0) return;

            // Extract string from the last FormattedCharSequence
            class_5481 lastLine = getLines().get(lastIndex);
            StringBuilder builder = new StringBuilder();
            lastLine.accept((index, style, codePoint) -> {
                builder.appendCodePoint(codePoint);
                return true;
            });
            String truncatedLine = builder.toString();

            // Truncate the line to fit within maxWidth, accounting for ellipsis
            while (getFont().method_1727(truncatedLine + ellipsis) > getMaxWidth() && !truncatedLine.isEmpty()) {
                truncatedLine = truncatedLine.substring(0, truncatedLine.length() - 1);
            }

            // Replace the last line with the truncated line plus ellipsis
            getLines().set(lastIndex, class_2561.method_43470(truncatedLine + ellipsis).method_27696(class_2583.field_24360).method_30937());
        }

        // Update width and height
        setWidth(getLines().stream().mapToInt(getFont()::method_30880).max().orElse(0));
        setHeight(getFont().field_2000 * getLines().size());
    }

    @Override
    public void render(class_332 guiGraphics, int mouseX, int mouseY, float partialTick, int parentWidth, int parentHeight) {
        for (int i = 0; i < getLines().size(); i++) {
            guiGraphics.method_51430(
                    getFont(),
                    getLines().get(i),
                    getTotalX(),
                    getTotalY() + i * getFont().field_2000,
                    getColor(),
                    isDrawShadow()
            );
        }

        if (isRenderDebugBorder()) {
            guiGraphics.method_51738(getTotalX() + getUnusedSpaceX(), getTotalX() + getMaxWidth() + getUnusedSpaceX() - 1, getTotalY(), 0xFF0000FF);
            guiGraphics.method_51742(getTotalX() + getMaxWidth() + getUnusedSpaceX() - 1, getTotalY(), getTotalY() + method_25364() - 1, 0xFF0000FF);
            guiGraphics.method_51738(getTotalX() + getUnusedSpaceX(), getTotalX() + getMaxWidth() + getUnusedSpaceX() - 1, getTotalY() + method_25364() - 1, 0xFF0000FF);
            guiGraphics.method_51742(getTotalX() + getUnusedSpaceX(), getTotalY(), getTotalY() + method_25364() - 1, 0xFF0000FF);
        }
    }
}
