package com.daqem.uilib.mixin;

import com.daqem.uilib.api.component.IComponent;
import com.daqem.uilib.api.component.IComponentsParent;
import com.daqem.uilib.api.screen.IScreen;
import com.daqem.uilib.api.widget.IWidget;
import com.daqem.uilib.gui.AbstractScreen;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_6379;
import net.minecraft.class_8021;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_339.class)
public abstract class AbstractWidgetMixin implements class_4068, class_364, class_8021, class_6379, IWidget {

    @Shadow
    private int x;

    @Shadow
    private int y;

    private int uilib$parentX;
    private int uilib$parentY;

    @Override
    public int uilib$getParentX() {
        return this.uilib$parentX;
    }

    @Override
    public int uilib$getParentY() {
        return this.uilib$parentY;
    }

    @Override
    public void uilib$updateParentPosition(int parentX, int parentY) {
        this.uilib$parentX = parentX;
        this.uilib$parentY = parentY;

        if (this instanceof IComponentsParent componentsParent) {
            for (IComponent component : componentsParent.getComponents()) {
                component.updateParentPosition(method_46426(), method_46427(), method_25368(), method_25364());
            }
        }
    }

    @Inject(method = "getX()I", at = @At("RETURN"), cancellable = true)
    private void uilib$modifyGetX(CallbackInfoReturnable<Integer> cir) {
        if (class_310.method_1551().field_1755 instanceof IScreen) {
            cir.setReturnValue(this.x + this.uilib$parentX);
        }
    }

    @Inject(method = "getY()I", at = @At("RETURN"), cancellable = true)
    private void uilib$modifyGetY(CallbackInfoReturnable<Integer> cir) {
        if (class_310.method_1551().field_1755 instanceof IScreen) {
            cir.setReturnValue(this.y + this.uilib$parentY);
        }
    }
}
