package com.daqem.uilib.mixin;

import com.daqem.uilib.api.screen.IScreen;
import com.daqem.uilib.gui.AbstractScreen;
import org.objectweb.asm.Opcodes;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_6379;

@Mixin(class_437.class)
public abstract class ScreenMixin {

    @Shadow
    @Final
    private List<class_6379> narratables;

    @Redirect(
            method = "*",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/client/gui/screens/Screen;narratables:Ljava/util/List;",
                    opcode = Opcodes.GETFIELD
            )
    )
    private List<class_6379> redirectNarratables(class_437 instance) {
        if ((class_437) (Object) this instanceof IScreen screen) {
            Set<class_6379> widgets = new HashSet<>(narratables);
            for (class_364 widget : screen.children()) {
                if (widget instanceof class_6379 narratableEntry) {
                    widgets.add(narratableEntry);
                }
            }
            return new ArrayList<>(widgets);
        }
        return narratables;
    }
}
