/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.uilib.gui.component;

import com.daqem.uilib.api.component.IComponent;
import com.daqem.uilib.api.widget.IWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_437;

public abstract class AbstractComponent
implements IComponent {
    private boolean isCenteredHorizontally;
    private boolean isCenteredVertically;
    private int x;
    private int y;
    private int parentX;
    private int parentY;
    private int width;
    private int height;
    private final List<IComponent> components = new ArrayList<IComponent>();
    private final List<IWidget> widgets = new ArrayList<IWidget>();
    private boolean renderBeforeParent = false;
    private boolean renderDebugBorder = false;

    public AbstractComponent(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    @Override
    public boolean isCenteredHorizontally() {
        return this.isCenteredHorizontally;
    }

    @Override
    public boolean isCenteredVertically() {
        return this.isCenteredVertically;
    }

    @Override
    public boolean isCentered() {
        return this.isCenteredHorizontally && this.isCenteredVertically;
    }

    @Override
    public void centerHorizontally() {
        this.isCenteredHorizontally = true;
    }

    @Override
    public void centerVertically() {
        this.isCenteredVertically = true;
    }

    @Override
    public void center() {
        this.centerHorizontally();
        this.centerVertically();
    }

    @Override
    public void decenterHorizontally() {
        this.isCenteredHorizontally = false;
    }

    @Override
    public void decenterVertically() {
        this.isCenteredVertically = false;
    }

    @Override
    public void decenter() {
        this.decenterHorizontally();
        this.decenterVertically();
    }

    public void method_46421(int x) {
        this.x = x;
        this.positionUpdated();
    }

    public void method_46419(int y) {
        this.y = y;
        this.positionUpdated();
    }

    public int method_46426() {
        return this.x;
    }

    public int method_46427() {
        return this.y;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
        this.positionUpdated();
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
        this.positionUpdated();
    }

    @Override
    public int getParentX() {
        return this.parentX;
    }

    @Override
    public int getParentY() {
        return this.parentY;
    }

    @Override
    public int getTotalX() {
        return this.getParentX() + this.method_46426();
    }

    @Override
    public int getTotalY() {
        return this.getParentY() + this.method_46427();
    }

    public int method_25368() {
        return this.width;
    }

    public int method_25364() {
        return this.height;
    }

    public void method_48206(Consumer<class_339> consumer) {
        this.widgets.stream().filter(widget -> widget instanceof class_339).forEach(widget -> consumer.accept((class_339)widget));
        this.components.forEach(component -> component.method_48206(consumer));
    }

    @Override
    public List<IComponent> getComponents() {
        return this.components;
    }

    @Override
    public List<IWidget> getWidgets() {
        return this.widgets;
    }

    @Override
    public List<IWidget> getAllWidgets() {
        ArrayList<IWidget> allWidgets = new ArrayList<IWidget>(this.widgets);
        for (IComponent component : this.components) {
            allWidgets.addAll(component.getAllWidgets());
        }
        return allWidgets;
    }

    @Override
    public void getAllWidgetsMap(Map<IWidget, IComponent> map) {
        for (IWidget widget : this.widgets) {
            map.put(widget, this);
        }
        for (IComponent component : this.components) {
            component.getAllWidgetsMap(map);
        }
    }

    @Override
    public boolean isRenderBeforeParent() {
        return this.renderBeforeParent;
    }

    @Override
    public void setRenderBeforeParent(boolean renderBeforeParent) {
        this.renderBeforeParent = renderBeforeParent;
    }

    @Override
    public boolean isRenderDebugBorder() {
        return this.renderDebugBorder;
    }

    @Override
    public void setRenderDebugBorder(boolean renderDebugBorder) {
        this.renderDebugBorder = renderDebugBorder;
    }

    @Override
    public void positionUpdated() {
        for (IComponent component : this.components) {
            component.updateParentPosition(this.getTotalX(), this.getTotalY(), this.method_25368(), this.method_25364());
        }
        for (IWidget widget : this.widgets) {
            widget.uilib$updateParentPosition(this.getTotalX(), this.getTotalY());
        }
    }

    @Override
    public void updateParentPosition(int parentX, int parentY, int parentWidth, int parentHeight) {
        this.parentX = parentX;
        this.parentY = parentY;
        if (this.isCenteredHorizontally) {
            this.x = (parentWidth - this.width) / 2;
        }
        if (this.isCenteredVertically) {
            this.y = (parentHeight - this.height) / 2;
        }
        for (IComponent component : this.components) {
            component.updateParentPosition(this.getTotalX(), this.getTotalY(), this.width, this.height);
        }
        for (IWidget widget : this.widgets) {
            widget.uilib$updateParentPosition(this.getTotalX(), this.getTotalY());
        }
    }

    @Override
    public void addComponent(IComponent component) {
        this.components.add(component);
    }

    @Override
    public void addComponents(List<? extends IComponent> components) {
        this.components.addAll(components);
    }

    @Override
    public void removeComponent(IComponent component) {
        this.components.remove(component);
    }

    @Override
    public void removeComponents(List<? extends IComponent> components) {
        this.components.removeAll(components);
    }

    @Override
    public void clearComponents() {
        this.components.clear();
    }

    @Override
    public void addWidget(IWidget widget) {
        this.widgets.add(widget);
    }

    @Override
    public void addWidgets(List<? extends IWidget> widgets) {
        this.widgets.addAll(widgets);
    }

    @Override
    public void removeWidget(IWidget widget) {
        this.widgets.remove(widget);
    }

    @Override
    public void removeWidgets(List<? extends IWidget> widgets) {
        this.widgets.removeAll(widgets);
    }

    @Override
    public void clearOnlyWidgets() {
        this.widgets.clear();
    }

    @Override
    public void clear() {
        this.clearComponents();
        this.clearOnlyWidgets();
    }

    @Override
    public void renderBase(class_332 guiGraphics, int mouseX, int mouseY, float partialTick, int parentWidth, int parentHeight) {
        for (IComponent component : this.components.stream().filter(IComponent::isRenderBeforeParent).toList()) {
            component.renderBase(guiGraphics, mouseX, mouseY, partialTick, this.width, this.height);
        }
        this.render(guiGraphics, mouseX, mouseY, partialTick, parentWidth, parentHeight);
        if (this.isRenderDebugBorder()) {
            guiGraphics.method_51738(this.getTotalX(), this.getTotalX() + this.method_25368() - 1, this.getTotalY(), -1426128896);
            guiGraphics.method_51742(this.getTotalX() + this.method_25368() - 1, this.getTotalY(), this.getTotalY() + this.method_25364() - 1, -1426128896);
            guiGraphics.method_51738(this.getTotalX(), this.getTotalX() + this.method_25368() - 1, this.getTotalY() + this.method_25364() - 1, -1426128896);
            guiGraphics.method_51742(this.getTotalX(), this.getTotalY(), this.getTotalY() + this.method_25364() - 1, -1426128896);
        }
        for (IComponent component : this.components.stream().filter(c -> !c.isRenderBeforeParent()).toList()) {
            component.renderBase(guiGraphics, mouseX, mouseY, partialTick, this.width, this.height);
        }
        for (IWidget widget : this.widgets) {
            widget.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof class_437) {
            class_437 screen = class_4372;
            this.renderBase(guiGraphics, mouseX, mouseY, partialTick, screen.field_22789, screen.field_22790);
        }
    }
}

