/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.uilib.gui.component.text.multiline;

import com.daqem.uilib.gui.component.text.multiline.AbstractMultiLineTextComponent;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5481;

public class TruncatedMultiLineTextComponent
extends AbstractMultiLineTextComponent {
    private int maxLines;
    private String ellipsis = "...";

    public TruncatedMultiLineTextComponent(int x, int y, int maxWidth, int maxLines, class_2561 text) {
        super(x, y, maxWidth, text, false);
        this.maxLines = maxLines;
        this.updateSize();
    }

    public TruncatedMultiLineTextComponent(int x, int y, int maxWidth, int maxLines, class_2561 text, int color) {
        super(x, y, maxWidth, text, color, false);
        this.maxLines = maxLines;
        this.updateSize();
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    public void setMaxLines(int maxLines) {
        this.maxLines = maxLines;
    }

    public String getEllipsis() {
        return this.ellipsis;
    }

    public void setEllipsis(String ellipsis) {
        this.ellipsis = ellipsis;
    }

    @Override
    protected void updateSize() {
        this.setLines(class_2477.method_10517().method_30933(TruncatedMultiLineTextComponent.findOptimalLines(this.getFont(), this.getText(), this.getMaxWidth())));
        if (this.getLines().size() > this.maxLines) {
            ArrayList<class_5481> lines = new ArrayList<class_5481>(this.getLines());
            lines.subList(this.maxLines, lines.size()).clear();
            this.setLines(lines);
            int lastIndex = this.getLines().size() - 1;
            if (lastIndex < 0) {
                return;
            }
            class_5481 lastLine = this.getLines().get(lastIndex);
            StringBuilder builder = new StringBuilder();
            lastLine.accept((index, style, codePoint) -> {
                builder.appendCodePoint(codePoint);
                return true;
            });
            String truncatedLine = builder.toString();
            while (this.getFont().method_1727(truncatedLine + this.ellipsis) > this.getMaxWidth() && !truncatedLine.isEmpty()) {
                truncatedLine = truncatedLine.substring(0, truncatedLine.length() - 1);
            }
            this.getLines().set(lastIndex, class_2561.method_43470((String)(truncatedLine + this.ellipsis)).method_27696(class_2583.field_24360).method_30937());
        }
        this.setWidth(this.getLines().stream().mapToInt(arg_0 -> ((class_327)this.getFont()).method_30880(arg_0)).max().orElse(0));
        Objects.requireNonNull(this.getFont());
        this.setHeight(9 * this.getLines().size());
    }

    @Override
    public void render(class_332 guiGraphics, int mouseX, int mouseY, float partialTick, int parentWidth, int parentHeight) {
        for (int i = 0; i < this.getLines().size(); ++i) {
            class_327 class_3272 = this.getFont();
            int n = this.getTotalX();
            int n2 = this.getTotalY();
            Objects.requireNonNull(this.getFont());
            guiGraphics.method_51430(class_3272, this.getLines().get(i), n, n2 + i * 9, this.getColor(), this.isDrawShadow());
        }
        if (this.isRenderDebugBorder()) {
            guiGraphics.method_51738(this.getTotalX() + this.getUnusedSpaceX(), this.getTotalX() + this.getMaxWidth() + this.getUnusedSpaceX() - 1, this.getTotalY(), -16776961);
            guiGraphics.method_51742(this.getTotalX() + this.getMaxWidth() + this.getUnusedSpaceX() - 1, this.getTotalY(), this.getTotalY() + this.method_25364() - 1, -16776961);
            guiGraphics.method_51738(this.getTotalX() + this.getUnusedSpaceX(), this.getTotalX() + this.getMaxWidth() + this.getUnusedSpaceX() - 1, this.getTotalY() + this.method_25364() - 1, -16776961);
            guiGraphics.method_51742(this.getTotalX() + this.getUnusedSpaceX(), this.getTotalY(), this.getTotalY() + this.method_25364() - 1, -16776961);
        }
    }
}

