/*
 * Decompiled with CFR 0.152.
 */
package net.enderturret.minestuckcompat;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.MapCodec;
import net.enderturret.minestuckcompat.ConfigCondition;
import net.enderturret.minestuckcompat.MinestuckCompatConfig;
import net.enderturret.minestuckcompat.alchemy.mekanism.ChemicalConversionManager;
import net.enderturret.minestuckcompat.alchemy.rechiseled.RechiseledGristCosts;
import net.enderturret.minestuckcompat.api.init.MCInterpreterTypes;
import net.enderturret.minestuckcompat.command.AnalyzerCommand;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="minestuckcompat")
public final class MinestuckCompat {
    public static final String MOD_ID = "minestuckcompat";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"MinestuckCompat");
    private static final DeferredRegister<MapCodec<? extends ICondition>> CONDITIONS = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.CONDITION_CODECS, (String)"minestuckcompat");
    private static final Holder<MapCodec<? extends ICondition>> CONFIG_CONDITION = CONDITIONS.register("config", () -> ConfigCondition.CODEC);

    public MinestuckCompat(ModContainer mc, IEventBus modBus) {
        mc.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)MinestuckCompatConfig.COMMON_SPEC);
        MCInterpreterTypes.REGISTRY.register(modBus);
        CONDITIONS.register(modBus);
        if (ModList.get().isLoaded("rechiseled")) {
            NeoForge.EVENT_BUS.register(RechiseledGristCosts.class);
        }
        if (ModList.get().isLoaded("mekanism")) {
            NeoForge.EVENT_BUS.register(ChemicalConversionManager.class);
        }
        NeoForge.EVENT_BUS.addListener(this::registerCommands);
    }

    private void registerCommands(RegisterCommandsEvent e) {
        if (e.getCommandSelection() == Commands.CommandSelection.INTEGRATED) {
            AnalyzerCommand.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher());
        }
    }
}

