/*
 * Decompiled with CFR 0.152.
 */
package net.enderturret.minestuckcompat;

import java.util.HashMap;
import java.util.Map;
import net.enderturret.minestuckcompat.MinestuckCompat;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class MinestuckCompatConfig {
    static final ModConfigSpec COMMON_SPEC;
    private static final MinestuckCompatConfig COMMON_INSTANCE;
    public final ModConfigSpec.BooleanValue useExtraStuckInterpreters;
    public final ModConfigSpec.BooleanValue dumpGristlessItems;
    public final ModConfigSpec.BooleanValue dumpUnhandledRecipeTypes;
    public final ModConfigSpec.BooleanValue dumpUnhandledRecipeTypesFiltering;
    public final ModConfigSpec.BooleanValue checkConflictingCombinationRecipes;
    public final ModConfigSpec.BooleanValue debugDefaultInterpreterRecipeEligibility;
    public final ModConfigSpec.BooleanValue mysteriousConversionRecipes;
    private final Map<String, ModConfigSpec.BooleanValue> enabledRecipes = new HashMap<String, ModConfigSpec.BooleanValue>();

    private MinestuckCompatConfig(ModConfigSpec.Builder builder) {
        builder.comment("Settings related to grist costs.").push("grist");
        this.useExtraStuckInterpreters = builder.comment(new String[]{"By default, when ExtraStuck is installed Minestuck Compat disables their interpreters in favor of its own.", "Turning this config option on will make Minestuck Compat disable its overlapping interpreters and allow", "ExtraStuck's interpreters to load."}).define("useExtraStuckInterpreters", false);
        this.dumpGristlessItems = builder.comment(new String[]{"Whether or not to print a list of all items that lack grist costs to the log.", "This can be useful when building compatibility data packs.", "", "Unlike Minestuck's config option, this lists *all* items, not just those which are ingredients."}).define("dumpGristlessItems", !FMLEnvironment.production);
        this.dumpUnhandledRecipeTypes = builder.comment(new String[]{"Whether or not to print a list of all recipe types that lack interpreters to the log.", "This can be useful when building compatibility data packs."}).define("dumpUnhandledRecipeTypes", false);
        this.dumpUnhandledRecipeTypesFiltering = builder.comment(new String[]{"Whether or not to filter some (intentionally unsupported) recipe types out of the recipe type dump.", "Certain recipe types, like Mekanism's chemical-only recipe types, will always be filtered out,", "as they cannot realistically be supported due to limitations of Minestuck's grist cost system."}).define("dumpUnhandledRecipeTypesFiltering", true);
        this.debugDefaultInterpreterRecipeEligibility = builder.comment(new String[]{"Whether or not to print information about unhandled recipes that go through the 'minestuck:default'", "interpreter.", "", "These usually indicate recipe serializers that need special handling.", "For example because they report that they're special (i.e., hidden from the recipe book),", "or because they report no ingredients or results via the vanilla codepath (which means the", "recipe's internal representation may be considerably more advanced or abstracted).", "", "For the former (isSpecial() == true), see Create's recipes as an example.", "For the latter (ingredients and results are empty), see Mekanism's recipes as an example.", "", "In the case that the recipe is \"special\" but otherwise eligible, Minestuck Compat provides", "the \"minestuckcompat:simple\" interpreter, which can be instructed to allow \"special\"", "recipes by adding `\"ignore_simple\": false` to its definition. The interpreter is otherwise", "a one-to-one clone of Minestuck's default interpreter (besides allowing an added cost)."}).define("debugDefaultInterpreterRecipeEligibility", false);
        builder.comment("Settings for turning on/off grist cost integration for supported mods.").push("integration");
        this.defineEnabledRecipes(builder, "ae2", "Applied Energistics 2");
        this.defineEnabledRecipes(builder, "biomesoplenty", "Biomes O' Plenty");
        this.defineEnabledRecipes(builder, "create", "Create");
        this.defineEnabledRecipes(builder, "extradelight", "ExtraDelight");
        this.defineEnabledRecipes(builder, "farmersdelight", "Farmer's Delight");
        this.defineEnabledRecipes(builder, "immersiveengineering", "Immersive Engineering");
        this.defineEnabledRecipes(builder, "mekanism", "Mekanism");
        this.defineEnabledRecipes(builder, "minestuck", "Minestuck");
        this.defineEnabledRecipes(builder, "minecraft", "Minecraft");
        this.defineEnabledRecipes(builder, "appmek", "Applied Mekanistics");
        this.defineEnabledRecipes(builder, "buildersaddition2", "Builders Crafts & Additions 2");
        this.defineEnabledRecipes(builder, "createoreexcavation", "Create Ore Excavation");
        this.defineEnabledRecipes(builder, "dankstorage", "Dank Storage");
        this.defineEnabledRecipes(builder, "expandedstorage", "Expanded Storage");
        this.defineEnabledRecipes(builder, "framedblocks", "FramedBlocks");
        this.defineEnabledRecipes(builder, "gravestone", "GraveStone Mod");
        this.defineEnabledRecipes(builder, "hostilenetworks", "Hostile Neural Networks");
        this.defineEnabledRecipes(builder, "lootr", "Lootr");
        this.defineEnabledRecipes(builder, "supplementaries", "Supplementaries");
        builder.pop(2);
        this.checkConflictingCombinationRecipes = builder.comment("Whether or not to check for overlapping punch designix and totem lathe (combination) recipes.").define("checkConflictingCombinationRecipes", false);
        this.mysteriousConversionRecipes = builder.comment(new String[]{"Whether or not to add \"Mysterious Conversions\" for Minestuck's transforming weapons to JEI when Create is installed.", "Mods and resource packs can add their own such weapons by adding a mymod:minestuckcompat/swapping_weapons.json file."}).define("mysteriousConversionRecipes", true);
    }

    private void defineEnabledRecipes(ModConfigSpec.Builder builder, String modId, String name) {
        this.enabledRecipes.put(modId, builder.comment("Whether or not to enable Minestuck Compat's grist cost and combination recipes for " + name + ".").define(name, true));
    }

    public boolean isModEnabled(String modId) {
        ModConfigSpec.BooleanValue val = this.enabledRecipes.get(modId);
        if (val == null) {
            MinestuckCompat.LOGGER.warn("Unknown mod ID {} in config query", (Object)modId);
            return false;
        }
        return val.getAsBoolean();
    }

    public static MinestuckCompatConfig common() {
        return COMMON_INSTANCE;
    }

    static {
        Pair pair = new ModConfigSpec.Builder().configure(MinestuckCompatConfig::new);
        COMMON_SPEC = (ModConfigSpec)pair.getRight();
        COMMON_INSTANCE = (MinestuckCompatConfig)pair.getLeft();
    }
}

