/*
 * Decompiled with CFR 0.152.
 */
package net.enderturret.minestuckcompat.alchemy;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.enderturret.minestuckcompat.alchemy.JeiHooks;
import net.enderturret.minestuckcompat.alchemy.analysis.BuiltinRecipeList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import org.jetbrains.annotations.ApiStatus;

@EventBusSubscriber(modid="minestuckcompat", value={Dist.CLIENT})
@ApiStatus.Internal
public final class ClientDataManager {
    public static final Map<Item, Item> SWAPPING_WEAPONS = new LinkedHashMap<Item, Item>();
    private static final Codec<Item> ITEM_CODEC = BuiltInRegistries.ITEM.byNameCodec();
    private static final Codec<Map<Item, Item>> CODEC = Codec.unboundedMap(ITEM_CODEC, ITEM_CODEC);

    @SubscribeEvent
    static void registerClientReloadListeners(RegisterClientReloadListenersEvent e) {
        e.registerReloadListener((PreparableReloadListener)((ResourceManagerReloadListener)resourceManager -> {
            SWAPPING_WEAPONS.clear();
            BuiltinRecipeList.parseResource(resourceManager, "minestuckcompat", "minestuckcompat/swapping_weapons.json", null, elem -> {
                SWAPPING_WEAPONS.putAll((Map)CODEC.parse((DynamicOps)JsonOps.INSTANCE, elem).getOrThrow(RuntimeException::new));
                return List.of();
            });
            if (ModList.get().isLoaded("create") && ModList.get().isLoaded("jei")) {
                JeiHooks.registerConversions();
            }
        }));
    }
}

