/*
 * Decompiled with CFR 0.152.
 */
package net.enderturret.minestuckcompat.alchemy;

import com.mraof.minestuck.api.alchemy.recipe.JeiGristCost;
import com.mraof.minestuck.api.alchemy.recipe.combination.CombinationMode;
import com.mraof.minestuck.api.alchemy.recipe.combination.JeiCombination;
import com.mraof.minestuck.item.MSItems;
import com.simibubi.create.compat.jei.ConversionRecipe;
import com.simibubi.create.compat.jei.category.MysteriousItemConversionCategory;
import java.util.HashMap;
import java.util.Map;
import net.enderturret.minestuckcompat.MinestuckCompatConfig;
import net.enderturret.minestuckcompat.alchemy.ClientDataManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class JeiHooks {
    private static final Map<JeiCombination, ResourceLocation> AND_IDS = new HashMap<JeiCombination, ResourceLocation>();
    private static final Map<JeiCombination, ResourceLocation> OR_IDS = new HashMap<JeiCombination, ResourceLocation>();
    private static final Map<JeiGristCost, ResourceLocation> GRIST_IDS = new HashMap<JeiGristCost, ResourceLocation>();
    private static boolean registered = false;

    @Nullable
    public static ResourceLocation getId(JeiCombination combination, CombinationMode mode) {
        return (mode == CombinationMode.AND ? AND_IDS : OR_IDS).get(combination);
    }

    @Nullable
    public static ResourceLocation getId(JeiGristCost cost) {
        return GRIST_IDS.get(cost);
    }

    public static void putId(JeiCombination combination, CombinationMode mode, ResourceLocation id) {
        (mode == CombinationMode.AND ? AND_IDS : OR_IDS).put(combination, id);
    }

    public static void putId(JeiGristCost cost, ResourceLocation id) {
        GRIST_IDS.put(cost, id);
    }

    public static void registerConversions() {
        if (!((Boolean)MinestuckCompatConfig.common().mysteriousConversionRecipes.get()).booleanValue()) {
            return;
        }
        if (registered) {
            return;
        }
        registered = true;
        for (Map.Entry<Item, Item> entry : ClientDataManager.SWAPPING_WEAPONS.entrySet()) {
            JeiHooks.registerConversion((ItemLike)entry.getKey(), (ItemLike)entry.getValue());
            JeiHooks.registerConversion((ItemLike)entry.getValue(), (ItemLike)entry.getKey());
        }
        JeiHooks.registerConversion((ItemLike)MSItems.CANDY_CANE, (ItemLike)MSItems.SHARP_CANDY_CANE);
        JeiHooks.registerConversion((ItemLike)MSItems.FROSTTOOTH, (ItemLike)MSItems.ICE_SHARD);
    }

    private static void registerRecipricolConversion(ItemLike from, ItemLike to) {
        JeiHooks.registerConversion(from, to);
        JeiHooks.registerConversion(to, from);
    }

    private static void registerConversion(ItemLike from, ItemLike to) {
        MysteriousItemConversionCategory.RECIPES.add(ConversionRecipe.create((ItemStack)new ItemStack(from), (ItemStack)new ItemStack(to)));
    }
}

