/*
 * Decompiled with CFR 0.152.
 */
package net.enderturret.minestuckcompat.alchemy.ae2;

import appeng.core.definitions.AEBlocks;
import appeng.recipes.handlers.InscriberProcessType;
import appeng.recipes.handlers.InscriberRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.alchemy.recipe.generator.recipe.RecipeInterpreter;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.MutableGristSet;
import com.mraof.minestuck.api.alchemy.recipe.generator.GeneratorCallback;
import com.mraof.minestuck.api.alchemy.recipe.generator.LookupTracker;
import net.enderturret.minestuckcompat.api.alchemy.AbstractCostAddingRecipeInterpreter;
import net.enderturret.minestuckcompat.api.alchemy.AnalyzableRecipeInterpreter;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Recipe;

public final class InscriberInterpreter
extends AbstractCostAddingRecipeInterpreter
implements AnalyzableRecipeInterpreter {
    public static final MapCodec<InscriberInterpreter> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)COST_FIELD.forGetter(AbstractCostAddingRecipeInterpreter::addedCost)).apply((Applicative)instance, InscriberInterpreter::new));

    public InscriberInterpreter(GristSet.Immutable addedCost) {
        super(addedCost);
    }

    public MapCodec<? extends RecipeInterpreter> codec() {
        return CODEC;
    }

    @Override
    public GristSet generateCost(Recipe<?> recipe, Item output, GeneratorCallback callback) {
        MutableGristSet totalCost = MutableGristSet.newDefault();
        if (recipe instanceof InscriberRecipe) {
            InscriberRecipe r = (InscriberRecipe)recipe;
            if (r.getProcessType() != InscriberProcessType.INSCRIBE && !InscriberInterpreter.account(totalCost, callback, r.getTopOptional())) {
                return null;
            }
            if (!InscriberInterpreter.account(totalCost, callback, r.getMiddleInput())) {
                return null;
            }
            if (!InscriberInterpreter.account(totalCost, callback, r.getBottomOptional())) {
                return null;
            }
        } else {
            totalCost = this.ingredientCost(recipe, callback);
        }
        return this.finalizeGristCosts(totalCost, recipe, output);
    }

    @Override
    public void reportCraftingStation(Recipe<?> recipe, LookupTracker tracker) {
        tracker.report(AEBlocks.INSCRIBER.asItem());
    }
}

