/*
 * Decompiled with CFR 0.152.
 */
package net.enderturret.minestuckcompat.alchemy.analysis;

import com.mraof.minestuck.api.alchemy.recipe.generator.LookupTracker;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.enderturret.minestuckcompat.alchemy.analysis.SimpleIngredient;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public final class AnalyzingLookupTracker
implements LookupTracker {
    private final Set<SimpleIngredient> ingredients = new LinkedHashSet<SimpleIngredient>();

    public Set<SimpleIngredient> getIngredients() {
        return Collections.unmodifiableSet(this.ingredients);
    }

    public void report(Item item) {
        if (item == Items.AIR) {
            return;
        }
        this.ingredients.add(SimpleIngredient.of((ItemLike)item));
    }

    public void report(Ingredient ingredient) {
        if (ingredient == Ingredient.EMPTY) {
            return;
        }
        this.ingredients.add(SimpleIngredient.of(ingredient));
    }

    public void report(TagKey<Item> tag) {
        this.ingredients.add(SimpleIngredient.of(tag));
    }

    public void report(List<Item> ingredient) {
        if (ingredient.isEmpty()) {
            return;
        }
        this.ingredients.add(new SimpleIngredient(List.copyOf(ingredient)));
    }
}

