/*
 * Decompiled with CFR 0.152.
 */
package net.enderturret.minestuckcompat.alchemy.analysis;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

record SimpleIngredient(List<Item> items) {
    static final SimpleIngredient INVALID = new SimpleIngredient(List.of(Items.AIR));

    static SimpleIngredient of(ItemLike item) {
        return new SimpleIngredient(List.of(item.asItem()));
    }

    static SimpleIngredient of(TagKey<Item> tag) {
        Optional<List> list = BuiltInRegistries.ITEM.getTag(tag).map(named -> named.stream().map(Holder::value).toList());
        if (list.isEmpty() || list.get().isEmpty()) {
            return INVALID;
        }
        return new SimpleIngredient(list.get());
    }

    static SimpleIngredient of(Ingredient ing) {
        ArrayList<Item> items = new ArrayList<Item>(1);
        if (ing.isCustom()) {
            for (ItemStack item : ing.getItems()) {
                items.add(item.getItem());
            }
        } else {
            for (Ingredient.Value val : ing.getValues()) {
                if (val instanceof Ingredient.ItemValue) {
                    Ingredient.ItemValue item = (Ingredient.ItemValue)val;
                    items.add(item.item().getItem());
                    continue;
                }
                if (!(val instanceof Ingredient.TagValue)) continue;
                Ingredient.TagValue tag = (Ingredient.TagValue)val;
                items.addAll(SimpleIngredient.of((TagKey<Item>)tag.tag()).items);
            }
        }
        return new SimpleIngredient(List.copyOf(items));
    }

    @Override
    public final String toString() {
        return "[" + this.items.stream().map(item -> item.builtInRegistryHolder().getRegisteredName()).collect(Collectors.joining(", ")) + "]";
    }
}

