/*
 * Decompiled with CFR 0.152.
 */
package net.enderturret.minestuckcompat.alchemy.create;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.alchemy.recipe.generator.recipe.RecipeInterpreter;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.MutableGristSet;
import com.mraof.minestuck.api.alchemy.recipe.generator.GeneratorCallback;
import com.mraof.minestuck.api.alchemy.recipe.generator.LookupTracker;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.content.processing.recipe.StandardProcessingRecipe;
import java.util.List;
import net.enderturret.minestuckcompat.api.alchemy.AbstractCostAddingRecipeInterpreter;
import net.enderturret.minestuckcompat.api.alchemy.AnalyzableRecipeInterpreter;
import net.enderturret.minestuckcompat.api.alchemy.FluidHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.Nullable;

public final class FluidProcessingInterpreter
extends AbstractCostAddingRecipeInterpreter.Typed<StandardProcessingRecipe<?>>
implements AnalyzableRecipeInterpreter {
    public static final MapCodec<FluidProcessingInterpreter> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)GristSet.Codecs.MAP_CODEC.optionalFieldOf("added_cost", (Object)GristSet.EMPTY).forGetter(AbstractCostAddingRecipeInterpreter::addedCost), (App)GristSet.Codecs.MAP_CODEC.optionalFieldOf("heated_cost", (Object)GristSet.EMPTY).forGetter(FluidProcessingInterpreter::heatedCost)).apply((Applicative)instance, FluidProcessingInterpreter::new));
    private final GristSet.Immutable heatedCost;

    public FluidProcessingInterpreter(GristSet.Immutable addedCost, GristSet.Immutable heatedCost) {
        super(StandardProcessingRecipe.class, addedCost);
        this.heatedCost = heatedCost;
    }

    public GristSet.Immutable heatedCost() {
        return this.heatedCost;
    }

    public MapCodec<? extends RecipeInterpreter> codec() {
        return CODEC;
    }

    @Override
    protected List<ItemStack> getOutputItemStacksTyped(StandardProcessingRecipe<?> recipe) {
        return recipe.getRollableResults().stream().map(o -> o.getStack()).toList();
    }

    @Override
    @Nullable
    protected MutableGristSet generateCost(MutableGristSet totalCost, StandardProcessingRecipe<?> recipe, Item output, GeneratorCallback callback) {
        for (Ingredient ing : recipe.getIngredients()) {
            if (FluidProcessingInterpreter.account(totalCost, callback, ing)) continue;
            return null;
        }
        for (Ingredient ing : recipe.getFluidIngredients()) {
            if (FluidHelper.account(totalCost, callback, ing.getMatchingFluidStacks(), ing.getRequiredAmount())) continue;
            return null;
        }
        return totalCost;
    }

    @Override
    @Nullable
    protected MutableGristSet ingredientCost(Recipe<?> recipe, GeneratorCallback callback) {
        return MutableGristSet.newDefault();
    }

    @Override
    protected void reportPreliminaryLookupsTyped(StandardProcessingRecipe<?> recipe, LookupTracker tracker) {
        for (Ingredient ing : recipe.getIngredients()) {
            tracker.report(ing);
        }
        for (Ingredient ing : recipe.getFluidIngredients()) {
            FluidHelper.report(tracker, ing.getMatchingFluidStacks());
        }
    }

    @Override
    public void reportCraftingStation(Recipe<?> recipe, LookupTracker tracker) {
        StandardProcessingRecipe r;
        RecipeType type = recipe.getType();
        if (type == AllRecipeTypes.COMPACTING.getType()) {
            tracker.report(AllBlocks.BASIN.asItem());
            tracker.report(AllBlocks.MECHANICAL_PRESS.asItem());
        }
        if (type == AllRecipeTypes.MIXING.getType()) {
            tracker.report(AllBlocks.BASIN.asItem());
            tracker.report(AllBlocks.MECHANICAL_MIXER.asItem());
        }
        if (type == AllRecipeTypes.FILLING.getType()) {
            tracker.report(AllBlocks.SPOUT.asItem());
        }
        if (recipe instanceof StandardProcessingRecipe && (r = (StandardProcessingRecipe)recipe).getRequiredHeat() != HeatCondition.NONE) {
            tracker.report(AllBlocks.LIT_BLAZE_BURNER.asItem());
        }
    }
}

