/*
 * Decompiled with CFR 0.152.
 */
package net.enderturret.minestuckcompat.alchemy.create;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.alchemy.recipe.generator.recipe.RecipeInterpreter;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.MutableGristSet;
import com.mraof.minestuck.api.alchemy.recipe.generator.GeneratorCallback;
import com.mraof.minestuck.api.alchemy.recipe.generator.LookupTracker;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.fluids.transfer.FillingRecipe;
import com.simibubi.create.content.kinetics.deployer.DeployerApplicationRecipe;
import com.simibubi.create.content.kinetics.press.PressingRecipe;
import com.simibubi.create.content.kinetics.saw.CuttingRecipe;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.content.processing.sequenced.SequencedRecipe;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import java.util.List;
import net.enderturret.minestuckcompat.MinestuckCompat;
import net.enderturret.minestuckcompat.api.alchemy.AbstractCostAddingRecipeInterpreter;
import net.enderturret.minestuckcompat.api.alchemy.AnalyzableRecipeInterpreter;
import net.enderturret.minestuckcompat.api.alchemy.FluidHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public final class SequencedAssemblyInterpreter
extends AbstractCostAddingRecipeInterpreter.Typed<SequencedAssemblyRecipe>
implements AnalyzableRecipeInterpreter {
    public static final MapCodec<SequencedAssemblyInterpreter> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)GristSet.Codecs.MAP_CODEC.optionalFieldOf("added_cost", (Object)GristSet.EMPTY).forGetter(AbstractCostAddingRecipeInterpreter::addedCost), (App)GristSet.Codecs.MAP_CODEC.optionalFieldOf("deploy_cost", (Object)GristSet.EMPTY).forGetter(SequencedAssemblyInterpreter::deployCost), (App)GristSet.Codecs.MAP_CODEC.optionalFieldOf("press_cost", (Object)GristSet.EMPTY).forGetter(SequencedAssemblyInterpreter::pressCost), (App)GristSet.Codecs.MAP_CODEC.optionalFieldOf("fill_cost", (Object)GristSet.EMPTY).forGetter(SequencedAssemblyInterpreter::fillCost), (App)GristSet.Codecs.MAP_CODEC.optionalFieldOf("cut_cost", (Object)GristSet.EMPTY).forGetter(SequencedAssemblyInterpreter::cutCost)).apply((Applicative)instance, SequencedAssemblyInterpreter::new));
    private final GristSet.Immutable deployCost;
    private final GristSet.Immutable pressCost;
    private final GristSet.Immutable fillCost;
    private final GristSet.Immutable cutCost;

    public SequencedAssemblyInterpreter(GristSet.Immutable addedCost, GristSet.Immutable deployCost, GristSet.Immutable pressCost, GristSet.Immutable fillCost, GristSet.Immutable cutCost) {
        super(SequencedAssemblyRecipe.class, addedCost);
        this.deployCost = deployCost;
        this.pressCost = pressCost;
        this.fillCost = fillCost;
        this.cutCost = cutCost;
    }

    public GristSet.Immutable deployCost() {
        return this.deployCost;
    }

    public GristSet.Immutable pressCost() {
        return this.pressCost;
    }

    public GristSet.Immutable fillCost() {
        return this.fillCost;
    }

    public GristSet.Immutable cutCost() {
        return this.cutCost;
    }

    public MapCodec<? extends RecipeInterpreter> codec() {
        return CODEC;
    }

    @Override
    protected List<ItemStack> getOutputItemStacksTyped(SequencedAssemblyRecipe recipe) {
        ItemStack result = recipe.getResultItem(null);
        ItemStack transitionalItem = recipe.getTransitionalItem();
        if (recipe.getIngredient().getValues().length == 1 && SequencedAssemblyInterpreter.uncachedTest(recipe.getIngredient(), transitionalItem)) {
            return List.of(result);
        }
        return List.of(result, transitionalItem);
    }

    private static boolean uncachedTest(Ingredient ingredient, ItemStack input) {
        if (ingredient.isCustom()) {
            return ingredient.test(input);
        }
        for (Ingredient.Value val : ingredient.getValues()) {
            Ingredient.TagValue tag;
            Ingredient.ItemValue item;
            if (val instanceof Ingredient.ItemValue && (item = (Ingredient.ItemValue)val).item().is(input.getItem())) {
                return true;
            }
            if (!(val instanceof Ingredient.TagValue) || !input.is((tag = (Ingredient.TagValue)val).tag())) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    protected MutableGristSet generateCost(MutableGristSet totalCost, SequencedAssemblyRecipe recipe, Item output, GeneratorCallback callback) {
        if (!SequencedAssemblyInterpreter.account(totalCost, callback, recipe.getIngredient())) {
            return null;
        }
        if (output == recipe.getTransitionalItem().getItem()) {
            return totalCost;
        }
        MutableGristSet sequenceCost = recipe.getLoops() == 1 ? totalCost : MutableGristSet.newDefault();
        for (SequencedRecipe seq : recipe.getSequence()) {
            if (this.handleSequenceRecipe(recipe, (Recipe<?>)seq.getRecipe(), sequenceCost, output, callback)) continue;
            return null;
        }
        if (recipe.getLoops() > 1) {
            sequenceCost.scale(recipe.getLoops());
            totalCost.add((GristSet)sequenceCost);
        }
        return totalCost;
    }

    @Override
    protected void reportPreliminaryLookupsTyped(SequencedAssemblyRecipe recipe, LookupTracker tracker) {
        tracker.report(recipe.getIngredient());
        for (SequencedRecipe seq : recipe.getSequence()) {
            Object object = seq.getRecipe();
            if (object instanceof DeployerApplicationRecipe) {
                DeployerApplicationRecipe r2 = (DeployerApplicationRecipe)object;
                for (Ingredient ing : r2.getIngredients()) {
                    if (ing.test(recipe.getTransitionalItem())) continue;
                    tracker.report(ing);
                }
                continue;
            }
            object = seq.getRecipe();
            if (!(object instanceof FillingRecipe)) continue;
            FillingRecipe r2 = (FillingRecipe)object;
            FluidHelper.report(tracker, (FluidStack)r2.getRequiredFluid().getMatchingFluidStacks().get(0));
        }
    }

    @Override
    public void reportCraftingStation(Recipe<?> recipe, LookupTracker tracker) {
        if (recipe instanceof SequencedAssemblyRecipe) {
            SequencedAssemblyRecipe r = (SequencedAssemblyRecipe)recipe;
            for (SequencedRecipe seq : r.getSequence()) {
                if (seq.getRecipe() instanceof DeployerApplicationRecipe) {
                    tracker.report(AllBlocks.DEPLOYER.asItem());
                    continue;
                }
                if (seq.getRecipe() instanceof PressingRecipe) {
                    tracker.report(AllBlocks.MECHANICAL_PRESS.asItem());
                    continue;
                }
                if (seq.getRecipe() instanceof FillingRecipe) {
                    tracker.report(AllBlocks.SPOUT.asItem());
                    continue;
                }
                if (!(seq.getRecipe() instanceof CuttingRecipe)) continue;
                tracker.report(AllBlocks.MECHANICAL_SAW.asItem());
            }
        }
    }

    private boolean handleSequenceRecipe(SequencedAssemblyRecipe r, Recipe<?> seq, MutableGristSet sequenceCost, Item output, GeneratorCallback callback) {
        if (seq instanceof DeployerApplicationRecipe) {
            DeployerApplicationRecipe r2 = (DeployerApplicationRecipe)seq;
            sequenceCost.add((GristSet)this.deployCost);
            for (Ingredient ing : r2.getIngredients()) {
                if (ing.test(r.getTransitionalItem()) || SequencedAssemblyInterpreter.account(sequenceCost, callback, ing)) continue;
                return false;
            }
        } else if (seq instanceof PressingRecipe) {
            sequenceCost.add((GristSet)this.pressCost);
        } else if (seq instanceof CuttingRecipe) {
            sequenceCost.add((GristSet)this.cutCost);
        } else if (seq instanceof FillingRecipe) {
            FillingRecipe r2 = (FillingRecipe)seq;
            sequenceCost.add((GristSet)this.fillCost);
            FluidIngredient fluid = r2.getRequiredFluid();
            if (!FluidHelper.account(sequenceCost, callback, fluid.getMatchingFluidStacks(), fluid.getRequiredAmount())) {
                return false;
            }
        } else {
            MinestuckCompat.LOGGER.warn("Don't know how to handle a {} in a SequencedAssemblyRecipe (from {})!", (Object)seq.getClass().getSimpleName(), (Object)output);
            return false;
        }
        return true;
    }
}

