/*
 * Decompiled with CFR 0.152.
 */
package net.enderturret.minestuckcompat.alchemy.extradelight;

import com.lance5057.extradelight.ExtraDelightItems;
import com.lance5057.extradelight.ExtraDelightRecipes;
import com.lance5057.extradelight.workstations.chiller.ChillerRecipe;
import com.lance5057.extradelight.workstations.mixingbowl.recipes.MixingBowlRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.alchemy.recipe.generator.recipe.RecipeInterpreter;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.MutableGristSet;
import com.mraof.minestuck.api.alchemy.recipe.generator.GeneratorCallback;
import com.mraof.minestuck.api.alchemy.recipe.generator.LookupTracker;
import java.util.List;
import net.enderturret.minestuckcompat.api.alchemy.AbstractCostAddingRecipeInterpreter;
import net.enderturret.minestuckcompat.api.alchemy.AnalyzableRecipeInterpreter;
import net.enderturret.minestuckcompat.api.alchemy.FluidHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.Nullable;

public final class ExtraDelightFluidInterpreter
extends AbstractCostAddingRecipeInterpreter
implements AnalyzableRecipeInterpreter {
    public static final MapCodec<ExtraDelightFluidInterpreter> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)GristSet.Codecs.MAP_CODEC.optionalFieldOf("added_cost", (Object)GristSet.EMPTY).forGetter(AbstractCostAddingRecipeInterpreter::addedCost)).apply((Applicative)instance, ExtraDelightFluidInterpreter::new));

    public ExtraDelightFluidInterpreter(GristSet.Immutable addedCost) {
        super(addedCost);
    }

    public MapCodec<? extends RecipeInterpreter> codec() {
        return CODEC;
    }

    @Override
    public List<ItemStack> getOutputItemStacks(Recipe<?> recipe) {
        return super.getOutputItemStacks(recipe);
    }

    @Override
    @Nullable
    protected MutableGristSet ingredientCost(Recipe<?> recipe, GeneratorCallback callback) {
        MutableGristSet totalCost = MutableGristSet.newDefault();
        for (Ingredient ingredient : recipe.getIngredients()) {
            if (ExtraDelightFluidInterpreter.account(totalCost, callback, ingredient)) continue;
            return null;
        }
        for (SizedFluidIngredient sizedFluidIngredient : this.getFluidInputs(recipe)) {
            if (FluidHelper.account(totalCost, callback, sizedFluidIngredient)) continue;
            return null;
        }
        return totalCost;
    }

    @Override
    @Nullable
    public GristSet generateCost(Recipe<?> recipe, Item output, GeneratorCallback callback) {
        GristSet ret = super.generateCost(recipe, output, callback);
        if (ret == null) {
            return null;
        }
        ItemStack container = ItemStack.EMPTY;
        if (recipe instanceof MixingBowlRecipe) {
            MixingBowlRecipe r = (MixingBowlRecipe)recipe;
            container = r.getContainer();
        } else if (recipe instanceof ChillerRecipe) {
            ChillerRecipe r = (ChillerRecipe)recipe;
            container = r.getOutputContainer();
        }
        if (!container.isEmpty() && !ExtraDelightFluidInterpreter.account((MutableGristSet)ret, callback, container.getItem())) {
            return null;
        }
        return ret;
    }

    @Override
    public void reportPreliminaryLookups(Recipe<?> recipe, LookupTracker tracker) {
        for (Ingredient ingredient : recipe.getIngredients()) {
            tracker.report(ingredient);
        }
        for (SizedFluidIngredient sizedFluidIngredient : this.getFluidInputs(recipe)) {
            FluidHelper.report(tracker, sizedFluidIngredient.ingredient());
        }
    }

    private Iterable<SizedFluidIngredient> getFluidInputs(Recipe<?> recipe) {
        if (recipe instanceof MixingBowlRecipe) {
            MixingBowlRecipe r = (MixingBowlRecipe)recipe;
            return r.getFluids();
        }
        if (recipe instanceof ChillerRecipe) {
            ChillerRecipe r = (ChillerRecipe)recipe;
            return r.getFluid().isEmpty() ? List.of() : List.of(SizedFluidIngredient.of((FluidStack)r.getFluid()));
        }
        return List.of();
    }

    @Override
    public void reportCraftingStation(Recipe<?> recipe, LookupTracker tracker) {
        RecipeType type = recipe.getType();
        if (type == ExtraDelightRecipes.MIXING_BOWL.get()) {
            tracker.report((Item)ExtraDelightItems.MIXING_BOWL.get());
        }
        if (type == ExtraDelightRecipes.CHILLER.get()) {
            tracker.report((Item)ExtraDelightItems.CHILLER.get());
        }
    }
}

