/*
 * Decompiled with CFR 0.152.
 */
package net.enderturret.minestuckcompat.alchemy.extradelight;

import com.lance5057.extradelight.ExtraDelightItems;
import com.lance5057.extradelight.workstations.vat.recipes.VatRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.alchemy.recipe.generator.recipe.RecipeInterpreter;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.MutableGristSet;
import com.mraof.minestuck.api.alchemy.recipe.generator.GeneratorCallback;
import com.mraof.minestuck.api.alchemy.recipe.generator.LookupTracker;
import java.util.List;
import net.enderturret.minestuckcompat.api.alchemy.AbstractCostAddingRecipeInterpreter;
import net.enderturret.minestuckcompat.api.alchemy.AnalyzableRecipeInterpreter;
import net.enderturret.minestuckcompat.api.alchemy.FluidHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import org.jetbrains.annotations.Nullable;

public final class FermentingInterpreter
extends AbstractCostAddingRecipeInterpreter.Typed<VatRecipe>
implements AnalyzableRecipeInterpreter {
    public static final MapCodec<FermentingInterpreter> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)COST_FIELD.forGetter(AbstractCostAddingRecipeInterpreter::addedCost), (App)GristSet.Codecs.MAP_CODEC.optionalFieldOf("cost_per_day", (Object)GristSet.EMPTY).forGetter(FermentingInterpreter::costPerDay), (App)Codec.FLOAT.optionalFieldOf("cost_per_day_multiplier", (Object)Float.valueOf(1.0f)).forGetter(FermentingInterpreter::costPerDayMultiplier)).apply((Applicative)instance, FermentingInterpreter::new));
    private final GristSet.Immutable costPerDay;
    private final float costPerDayMultiplier;

    public FermentingInterpreter(GristSet.Immutable addedCost, GristSet.Immutable costPerDay, float costPerDayMultiplier) {
        super(VatRecipe.class, addedCost);
        this.costPerDay = costPerDay;
        this.costPerDayMultiplier = costPerDayMultiplier;
    }

    public GristSet.Immutable costPerDay() {
        return this.costPerDay;
    }

    public float costPerDayMultiplier() {
        return this.costPerDayMultiplier;
    }

    public MapCodec<? extends RecipeInterpreter> codec() {
        return CODEC;
    }

    @Override
    protected List<ItemStack> getOutputItemStacksTyped(VatRecipe recipe) {
        return List.of(recipe.getResultItem(null));
    }

    @Override
    @Nullable
    protected MutableGristSet generateCost(MutableGristSet totalCost, VatRecipe recipe, Item output, GeneratorCallback callback) {
        int time = 0;
        for (VatRecipe.StageIngredient ing : recipe.getStageIngredients()) {
            if (!FermentingInterpreter.account(totalCost, callback, ing.ingredient)) {
                return null;
            }
            time += ing.time / 24000;
        }
        totalCost.add(FermentingInterpreter.scale((GristSet)this.costPerDay, (float)time * this.costPerDayMultiplier, false));
        if (!FluidHelper.account(totalCost, callback, recipe.getFluid())) {
            return null;
        }
        for (int i = 0; i < recipe.getUsedItem().getCount(); ++i) {
            if (FermentingInterpreter.account(totalCost, callback, recipe.getUsedItem().getItem())) continue;
            return null;
        }
        return totalCost;
    }

    @Override
    protected void reportPreliminaryLookupsTyped(VatRecipe recipe, LookupTracker tracker) {
    }

    @Override
    public void reportCraftingStation(Recipe<?> recipe, LookupTracker tracker) {
        tracker.report(ExtraDelightItems.VAT.asItem());
    }
}

