/*
 * Decompiled with CFR 0.152.
 */
package net.enderturret.minestuckcompat.alchemy.ie;

import blusunrize.immersiveengineering.api.EnumMetals;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.TagOutput;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEItems;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.alchemy.recipe.generator.recipe.RecipeInterpreter;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.MutableGristSet;
import com.mraof.minestuck.api.alchemy.recipe.generator.GeneratorCallback;
import com.mraof.minestuck.api.alchemy.recipe.generator.LookupTracker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.enderturret.minestuckcompat.MinestuckCompat;
import net.enderturret.minestuckcompat.api.alchemy.AbstractCostAddingRecipeInterpreter;
import net.enderturret.minestuckcompat.api.alchemy.AnalyzableRecipeInterpreter;
import net.enderturret.minestuckcompat.api.alchemy.FluidHelper;
import net.enderturret.minestuckcompat.mixin.feature.immersiveengineering.TagOutputAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.Nullable;

public final class MultiblockInterpreter
extends AbstractCostAddingRecipeInterpreter.Typed<MultiblockRecipe>
implements AnalyzableRecipeInterpreter {
    public static final MapCodec<MultiblockInterpreter> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)COST_FIELD.forGetter(AbstractCostAddingRecipeInterpreter::addedCost)).apply((Applicative)instance, MultiblockInterpreter::new));
    private boolean warned = false;
    private static Map<ResourceLocation, Item> tagToIeItem = null;

    public MultiblockInterpreter(GristSet.Immutable addedCost) {
        super(MultiblockRecipe.class, addedCost);
    }

    public MapCodec<? extends RecipeInterpreter> codec() {
        return CODEC;
    }

    @Override
    public List<ItemStack> getOutputItemStacksTyped(MultiblockRecipe recipe) {
        if (recipe instanceof BlueprintCraftingRecipe) {
            BlueprintCraftingRecipe r = (BlueprintCraftingRecipe)recipe;
            return MultiblockInterpreter.safeResolve(r.output);
        }
        if (!this.warned) {
            MinestuckCompat.LOGGER.warn("Called for unhandled MultiblockRecipe type {}! This may resolve tags too early!", (Object)recipe.getClass().getSimpleName());
            this.warned = true;
        }
        return super.getOutputItemStacks((Recipe<?>)recipe);
    }

    @Override
    @Nullable
    public MutableGristSet generateCost(MutableGristSet totalCost, MultiblockRecipe recipe, Item output, GeneratorCallback callback) {
        if (recipe.getItemInputs() != null) {
            for (IngredientWithSize ing : recipe.getItemInputs()) {
                if (MultiblockInterpreter.account(totalCost, callback, ing.getBaseIngredient(), ing.getCount())) continue;
                return null;
            }
        }
        if (recipe.getFluidInputs() != null) {
            for (IngredientWithSize ing : recipe.getFluidInputs()) {
                if (FluidHelper.account(totalCost, callback, (SizedFluidIngredient)ing)) continue;
                return null;
            }
        }
        return totalCost;
    }

    @Override
    public void reportPreliminaryLookupsTyped(MultiblockRecipe recipe, LookupTracker tracker) {
        if (recipe.getItemInputs() != null) {
            for (IngredientWithSize ing : recipe.getItemInputs()) {
                tracker.report(ing.getBaseIngredient());
            }
        }
    }

    @Override
    public void reportCraftingStation(Recipe<?> recipe, LookupTracker tracker) {
        if (recipe instanceof BlueprintCraftingRecipe) {
            tracker.report(IEBlocks.WoodenDevices.CRAFTING_TABLE.asItem());
        }
    }

    static List<ItemStack> safeResolve(TagOutput output) {
        if (output instanceof TagOutputAccess) {
            TagOutputAccess access = (TagOutputAccess)output;
            Either<IngredientWithSize, ItemStack> either = access.minestuckcompat$getRawData();
            if (either.right().isPresent()) {
                return List.of((ItemStack)either.right().get());
            }
            Ingredient ing = ((IngredientWithSize)either.left().get()).getBaseIngredient();
            ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
            for (Ingredient.Value val : ing.getValues()) {
                Item item;
                if (val instanceof Ingredient.ItemValue) {
                    Ingredient.ItemValue item2 = (Ingredient.ItemValue)val;
                    ret.add(item2.item());
                    continue;
                }
                if (!(val instanceof Ingredient.TagValue)) continue;
                Ingredient.TagValue tag = (Ingredient.TagValue)val;
                if (tagToIeItem == null) {
                    MultiblockInterpreter.buildTagMap();
                }
                if ((item = tagToIeItem.get(tag.tag().location())) == null) {
                    MinestuckCompat.LOGGER.warn("[Immersive Engineering] Missing entry for TagOutput {}", (Object)tag.tag().location());
                    continue;
                }
                ret.add(new ItemStack((ItemLike)item));
            }
            return List.copyOf(ret);
        }
        return List.of();
    }

    private static void buildTagMap() {
        tagToIeItem = new HashMap<ResourceLocation, Item>();
        for (EnumMetals metal : EnumMetals.values()) {
            String name = metal.tagName();
            tagToIeItem.put(MultiblockInterpreter.c("dusts/" + name), ((IEItems.ItemRegObject)IEItems.Metals.DUSTS.get(metal)).asItem());
            tagToIeItem.put(MultiblockInterpreter.c("ingots/" + name), ((IEItems.ItemRegObject)IEItems.Metals.INGOTS.get(metal)).asItem());
            tagToIeItem.put(MultiblockInterpreter.c("plates/" + name), ((IEItems.ItemRegObject)IEItems.Metals.PLATES.get(metal)).asItem());
        }
        tagToIeItem.put(MultiblockInterpreter.c("dusts/coal_coke"), IEItems.Ingredients.DUST_COKE.asItem());
        tagToIeItem.put(MultiblockInterpreter.c("dusts/hop_graphite"), IEItems.Ingredients.DUST_HOP_GRAPHITE.asItem());
        tagToIeItem.put(MultiblockInterpreter.c("rods/aluminum"), IEItems.Ingredients.STICK_ALUMINUM.asItem());
        tagToIeItem.put(MultiblockInterpreter.c("rods/iron"), IEItems.Ingredients.STICK_IRON.asItem());
        tagToIeItem.put(MultiblockInterpreter.c("rods/steel"), IEItems.Ingredients.STICK_STEEL.asItem());
        tagToIeItem.put(MultiblockInterpreter.c("wires/aluminum"), IEItems.Ingredients.WIRE_ALUMINUM.asItem());
        tagToIeItem.put(MultiblockInterpreter.c("wires/copper"), IEItems.Ingredients.WIRE_COPPER.asItem());
        tagToIeItem.put(MultiblockInterpreter.c("wires/electrum"), IEItems.Ingredients.WIRE_ELECTRUM.asItem());
        tagToIeItem.put(MultiblockInterpreter.c("wires/lead"), IEItems.Ingredients.WIRE_LEAD.asItem());
        tagToIeItem.put(MultiblockInterpreter.c("wires/steel"), IEItems.Ingredients.WIRE_STEEL.asItem());
        if (ModList.get().isLoaded("mekanism")) {
            tagToIeItem.put(MultiblockInterpreter.c("dusts/osmium"), (Item)BuiltInRegistries.ITEM.get(MultiblockInterpreter.mek("dust_osmium")));
            tagToIeItem.put(MultiblockInterpreter.c("dusts/tin"), (Item)BuiltInRegistries.ITEM.get(MultiblockInterpreter.mek("dust_tin")));
            tagToIeItem.put(MultiblockInterpreter.c("dusts/bronze"), (Item)BuiltInRegistries.ITEM.get(MultiblockInterpreter.mek("dust_bronze")));
            tagToIeItem.put(MultiblockInterpreter.c("dusts/coal"), (Item)BuiltInRegistries.ITEM.get(MultiblockInterpreter.mek("dust_coal")));
            tagToIeItem.put(MultiblockInterpreter.c("gems/fluorite"), (Item)BuiltInRegistries.ITEM.get(MultiblockInterpreter.mek("fluorite")));
            tagToIeItem.put(MultiblockInterpreter.c("ingots/bronze"), (Item)BuiltInRegistries.ITEM.get(MultiblockInterpreter.mek("ingot_bronze")));
        }
        if (ModList.get().isLoaded("create")) {
            tagToIeItem.put(MultiblockInterpreter.c("ingots/brass"), (Item)BuiltInRegistries.ITEM.get(MultiblockInterpreter.create("brass_ingot")));
            tagToIeItem.put(MultiblockInterpreter.c("plates/brass"), (Item)BuiltInRegistries.ITEM.get(MultiblockInterpreter.create("brass_plate")));
        }
    }

    private static ResourceLocation mek(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"mekanism", (String)path);
    }

    private static ResourceLocation create(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"create", (String)path);
    }

    private static ResourceLocation c(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"c", (String)path);
    }
}

