/*
 * Decompiled with CFR 0.152.
 */
package net.enderturret.minestuckcompat.alchemy.rechiseled;

import com.supermartijn642.rechiseled.chiseling.ChiselingEntry;
import com.supermartijn642.rechiseled.chiseling.ChiselingRecipe;
import com.supermartijn642.rechiseled.chiseling.ChiselingRecipes;
import net.enderturret.minestuckcompat.api.alchemy.RegisterGristCostProvidersEvent;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.SubscribeEvent;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class RechiseledGristCosts {
    @SubscribeEvent
    static void registerProviders(RegisterGristCostProvidersEvent event) {
        for (ChiselingRecipe recipe : ChiselingRecipes.getAllRecipes()) {
            if (recipe.getEntries().isEmpty()) continue;
            Item original = null;
            for (ChiselingEntry entry : recipe.getEntries()) {
                if (!entry.hasRegularItem() || !RechiseledGristCosts.isVanilla(entry.getRegularItem())) continue;
                original = entry.getRegularItem();
                break;
            }
            if (original == null) continue;
            for (ChiselingEntry entry : recipe.getEntries()) {
                if (entry.hasRegularItem() && !RechiseledGristCosts.isVanilla(entry.getRegularItem())) {
                    event.registerGristCostProvider(entry.getRegularItem(), original);
                }
                if (!entry.hasConnectingItem()) continue;
                event.registerGristCostProvider(entry.getConnectingItem(), original);
            }
        }
    }

    private static boolean isVanilla(Item item) {
        return item.builtInRegistryHolder().key().location().getNamespace().equals("minecraft");
    }
}

