/*
 * Decompiled with CFR 0.152.
 */
package net.enderturret.minestuckcompat.api.alchemy;

import com.mojang.serialization.MapCodec;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.MutableGristSet;
import com.mraof.minestuck.api.alchemy.recipe.generator.GeneratorCallback;
import com.mraof.minestuck.api.alchemy.recipe.generator.LookupTracker;
import java.util.List;
import net.enderturret.minestuckcompat.api.alchemy.AbstractRecipeInterpreter;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCostAddingRecipeInterpreter
extends AbstractRecipeInterpreter {
    protected final GristSet.Immutable addedCost;
    protected static final MapCodec<GristSet.Immutable> COST_FIELD = GristSet.Codecs.MAP_CODEC.optionalFieldOf("added_cost", (Object)GristSet.EMPTY);

    protected AbstractCostAddingRecipeInterpreter(GristSet.Immutable addedCost) {
        this.addedCost = addedCost;
    }

    public GristSet.Immutable addedCost() {
        return this.addedCost;
    }

    @Override
    @Nullable
    protected GristSet finalizeGristCosts(@Nullable MutableGristSet totalCost, int resultCount) {
        if (totalCost != null) {
            totalCost.add((GristSet)this.addedCost);
        }
        return super.finalizeGristCosts(totalCost, resultCount);
    }

    public static abstract class Typed<T extends Recipe<?>>
    extends AbstractCostAddingRecipeInterpreter {
        protected final Class<T> recipeClass;

        protected Typed(Class<T> recipeClass, GristSet.Immutable addedCost) {
            super(addedCost);
            this.recipeClass = recipeClass;
        }

        protected abstract List<ItemStack> getOutputItemStacksTyped(T var1);

        @Nullable
        protected abstract MutableGristSet generateCost(MutableGristSet var1, T var2, Item var3, GeneratorCallback var4);

        protected abstract void reportPreliminaryLookupsTyped(T var1, LookupTracker var2);

        @Override
        public List<ItemStack> getOutputItemStacks(Recipe<?> recipe) {
            if (this.recipeClass.isAssignableFrom(recipe.getClass())) {
                return this.getOutputItemStacksTyped(recipe);
            }
            return super.getOutputItemStacks(recipe);
        }

        @Override
        @Nullable
        public GristSet generateCost(Recipe<?> recipe, Item output, GeneratorCallback callback) {
            MutableGristSet totalCost = this.ingredientCost(recipe, callback);
            if (totalCost == null) {
                return null;
            }
            if (this.recipeClass.isAssignableFrom(recipe.getClass())) {
                totalCost = this.generateCost(totalCost, recipe, output, callback);
            }
            if (totalCost == null) {
                return null;
            }
            return this.finalizeGristCosts(totalCost, recipe, output);
        }

        @Override
        public void reportPreliminaryLookups(Recipe<?> recipe, LookupTracker tracker) {
            super.reportPreliminaryLookups(recipe, tracker);
            if (this.recipeClass.isAssignableFrom(recipe.getClass())) {
                this.reportPreliminaryLookupsTyped(recipe, tracker);
            }
        }
    }
}

