/*
 * Decompiled with CFR 0.152.
 */
package net.enderturret.minestuckcompat.api.alchemy;

import com.mraof.minestuck.alchemy.recipe.generator.recipe.RecipeInterpreter;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.MutableGristSet;
import com.mraof.minestuck.api.alchemy.recipe.generator.GeneratorCallback;
import com.mraof.minestuck.api.alchemy.recipe.generator.LookupTracker;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRecipeInterpreter
implements RecipeInterpreter {
    public final List<Item> getOutputItems(Recipe<?> recipe) {
        List<ItemStack> stacks = this.getOutputItemStacks(recipe);
        if (stacks.isEmpty()) {
            return List.of();
        }
        ArrayList<Item> ret = new ArrayList<Item>(stacks.size());
        for (ItemStack stack : stacks) {
            ret.add(stack.getItem());
        }
        return List.copyOf(ret);
    }

    public List<ItemStack> getOutputItemStacks(Recipe<?> recipe) {
        ItemStack stack = recipe.getResultItem(this.getLookupProvider());
        return stack.isEmpty() ? List.of() : List.of(stack);
    }

    @Nullable
    public GristSet generateCost(Recipe<?> recipe, Item output, GeneratorCallback callback) {
        if (recipe.isSpecial()) {
            return null;
        }
        return this.finalizeGristCosts(this.ingredientCost(recipe, callback), recipe, output);
    }

    public void reportPreliminaryLookups(Recipe<?> recipe, LookupTracker tracker) {
        for (Ingredient ing : recipe.getIngredients()) {
            if (ing == null) continue;
            tracker.report(ing);
        }
    }

    @Nullable
    protected HolderLookup.Provider getLookupProvider() {
        return null;
    }

    @Nullable
    protected MutableGristSet ingredientCost(Recipe<?> recipe, GeneratorCallback callback) {
        MutableGristSet totalCost = MutableGristSet.newDefault();
        for (Ingredient ingredient : recipe.getIngredients()) {
            if (ingredient == null || AbstractRecipeInterpreter.account(totalCost, callback, ingredient)) continue;
            return null;
        }
        return totalCost;
    }

    @Nullable
    protected GristSet finalizeGristCosts(@Nullable MutableGristSet totalCost, Recipe<?> recipe, Item output) {
        for (ItemStack out : this.getOutputItemStacks(recipe)) {
            if (out.getItem() != output) continue;
            return this.finalizeGristCosts(totalCost, out.getCount());
        }
        return this.finalizeGristCosts(totalCost, 1);
    }

    @Nullable
    protected GristSet finalizeGristCosts(@Nullable MutableGristSet totalCost, int resultCount) {
        if (totalCost != null) {
            totalCost.scale(1.0f / (float)resultCount, false);
        }
        return totalCost;
    }

    public static boolean account(MutableGristSet total, GeneratorCallback callback, SizedIngredient ingredient) {
        return AbstractRecipeInterpreter.account(total, callback, ingredient.ingredient(), ingredient.count());
    }

    public static boolean account(MutableGristSet total, GeneratorCallback callback, Ingredient ingredient, int count) {
        GristSet ingredientCost = callback.lookupCostFor(ingredient);
        if (ingredientCost == null) {
            return false;
        }
        for (int i = 0; i < count; ++i) {
            total.add(ingredientCost);
        }
        return true;
    }

    public static boolean account(MutableGristSet total, GeneratorCallback callback, Ingredient ingredient) {
        GristSet ingredientCost = callback.lookupCostFor(ingredient);
        if (ingredientCost == null) {
            return false;
        }
        total.add(ingredientCost);
        return true;
    }

    public static boolean account(MutableGristSet total, GeneratorCallback callback, Item item) {
        GristSet ingredientCost = callback.lookupCostFor(item);
        if (ingredientCost == null) {
            return false;
        }
        total.add(ingredientCost);
        return true;
    }

    public static GristSet scale(GristSet cost, float scale, boolean roundDown) {
        return scale == 1.0f ? cost : cost.mutableCopy().scale(scale, roundDown).asImmutable();
    }
}

