/*
 * Decompiled with CFR 0.152.
 */
package net.enderturret.minestuckcompat.api.alchemy;

import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.recipe.generator.GeneratedCostProvider;
import com.mraof.minestuck.api.alchemy.recipe.generator.GeneratorCallback;
import com.mraof.minestuck.api.alchemy.recipe.generator.GristCostResult;
import com.mraof.minestuck.api.alchemy.recipe.generator.LookupTracker;
import java.util.ArrayList;
import java.util.Map;
import net.enderturret.minestuckcompat.alchemy.SimpleCostProvider;
import net.enderturret.minestuckcompat.mixin.feature.outside_grist_costs.GeneratorProcessAccess;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.Event;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class RegisterGristCostProvidersEvent
extends Event {
    private final Map<Item, GristSet.Immutable> generatedCosts;
    private final GeneratorProcessAccess access;

    @ApiStatus.Internal
    public RegisterGristCostProvidersEvent(Map<Item, GristSet.Immutable> generatedCosts, GeneratorProcessAccess access) {
        this.generatedCosts = generatedCosts;
        this.access = access;
    }

    public void registerGristCostProvider(Item item, GristSet.Immutable cost) {
        this.registerGristCostProvider(item, (Item i, GeneratorCallback callback) -> cost);
    }

    public void registerGristCostProvider(Item item, final Item source) {
        this.registerGristCostProvider(item, new GristCostProvider(){

            @Override
            @Nullable
            public GristSet generate(Item item, GeneratorCallback callback) {
                return callback.lookupCostFor(source);
            }

            @Override
            public void reportPreliminaryLookups(LookupTracker tracker) {
                tracker.report(source);
            }
        });
    }

    public void registerGristCostProvider(Item item, final GristCostProvider provider) {
        this.register(item, new SimpleCostProvider(){

            @Override
            @Nullable
            protected GristSet generateCost(Item item, GeneratorCallback callback) {
                return provider.generate(item, callback);
            }

            @Override
            protected void putResult(Item item, @Nullable GristCostResult result) {
                if (result == null) {
                    return;
                }
                RegisterGristCostProvidersEvent.this.generatedCosts.putIfAbsent(item, result.cost().asImmutable());
            }

            @Override
            public void reportPreliminaryLookups(LookupTracker tracker) {
                provider.reportPreliminaryLookups(tracker);
            }
        });
    }

    private void register(Item item, GeneratedCostProvider provider) {
        this.access.minestuckcompat$getProvidersByItem().computeIfAbsent(item, k -> new ArrayList()).add(provider);
        this.access.minestuckcompat$getProviders().add(provider);
    }

    public static interface GristCostProvider {
        @Nullable
        public GristSet generate(Item var1, GeneratorCallback var2);

        default public void reportPreliminaryLookups(LookupTracker tracker) {
        }
    }
}

