/*
 * Decompiled with CFR 0.152.
 */
package net.enderturret.minestuckcompat.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import net.enderturret.minestuckcompat.alchemy.analysis.ObtainabilityAnalyzer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class AnalyzerCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"minestuckcompat").then(((LiteralArgumentBuilder)Commands.literal((String)"analyze").requires(src -> src.hasPermission(4))).executes(AnalyzerCommand::analyze)));
    }

    private static int analyze(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        MinecraftServer server = src.getServer();
        ResourceManager resourceManager = server.getResourceManager();
        ObtainabilityAnalyzer analyzer = new ObtainabilityAnalyzer(server.getRecipeManager(), resourceManager);
        List<Item> unobtainable = analyzer.check((msg, error) -> {
            if (error.booleanValue()) {
                src.sendFailure(msg);
            } else {
                src.sendSuccess(() -> msg, false);
            }
        });
        return 1;
    }
}

