/*
 * Decompiled with CFR 0.152.
 */
package net.enderturret.minestuckcompat.mixin.feature.debug;

import com.mraof.minestuck.alchemy.recipe.generator.recipe.DefaultInterpreter;
import com.mraof.minestuck.api.alchemy.MutableGristSet;
import com.mraof.minestuck.api.alchemy.recipe.generator.GeneratorCallback;
import java.util.List;
import net.enderturret.minestuckcompat.MinestuckCompat;
import net.enderturret.minestuckcompat.MinestuckCompatConfig;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Recipe;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={DefaultInterpreter.class})
public abstract class MixinDefaultInterpreter {
    @Inject(at={@At(value="RETURN")}, method={"getOutputItems"})
    private void minestuckcompat$printRecipeEligibilityFromOutput(Recipe<?> recipe, CallbackInfoReturnable<List<Item>> cir) {
        if (((List)cir.getReturnValue()).isEmpty() && MinestuckCompatConfig.common().debugDefaultInterpreterRecipeEligibility.getAsBoolean()) {
            MixinDefaultInterpreter.minestuckcompat$logWarn("Recipe {} (type {}, serializer {}) was unhandled because it had no result.", recipe);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"generateCost"})
    private void minestuckcompat$printRecipeEligibility(Recipe<?> recipe, Item output, GeneratorCallback callback, CallbackInfoReturnable<MutableGristSet> cir) {
        if (recipe.isSpecial() && !(recipe instanceof CustomRecipe) && MinestuckCompatConfig.common().debugDefaultInterpreterRecipeEligibility.getAsBoolean()) {
            MixinDefaultInterpreter.minestuckcompat$logWarn("Recipe {} (type {}, serializer {}) was unhandled because it was marked special.", recipe);
        } else if (recipe.getIngredients().isEmpty() && MinestuckCompatConfig.common().debugDefaultInterpreterRecipeEligibility.getAsBoolean()) {
            MixinDefaultInterpreter.minestuckcompat$logWarn("Recipe {} (type {}, serializer {}) was unhandled because it had no ingredients.", recipe);
        }
    }

    private static void minestuckcompat$logWarn(String message, Recipe<?> recipe) {
        MinestuckCompat.LOGGER.warn(message, new Object[]{recipe, BuiltInRegistries.RECIPE_TYPE.getKey((Object)recipe.getType()), BuiltInRegistries.RECIPE_SERIALIZER.getKey((Object)recipe.getSerializer())});
    }
}

