/*
 * Decompiled with CFR 0.152.
 */
package net.enderturret.minestuckcompat.perf;

import com.mraof.minestuck.api.alchemy.GristAmount;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.api.alchemy.GristTypes;
import com.mraof.minestuck.api.alchemy.MutableGristSet;
import java.util.List;
import java.util.Map;
import net.enderturret.minestuckcompat.perf.AbstractSmallGristSet;
import net.enderturret.minestuckcompat.perf.GristTypeHelper;
import net.enderturret.minestuckcompat.perf.SmallImmutableGristSet;

public final class SmallMutableGristSet
extends AbstractSmallGristSet
implements MutableGristSet {
    SmallMutableGristSet(int[] gristByType) {
        super(gristByType);
    }

    public SmallMutableGristSet() {
        this(new int[GristTypes.REGISTRY.size()]);
    }

    public static MutableGristSet create(GristSet set) {
        int[] gristByType = SmallMutableGristSet.gristByType(set, false);
        return new SmallMutableGristSet(gristByType);
    }

    public static MutableGristSet create(List<GristAmount> list) {
        return new SmallMutableGristSet(SmallMutableGristSet.gristByType(list));
    }

    public MutableGristSet set(GristType type, long amount) {
        this.gristByType[GristTypeHelper.id((GristType)type)] = (int)amount;
        return this;
    }

    public MutableGristSet add(GristType type, long amount) {
        int n = GristTypeHelper.id(type);
        this.gristByType[n] = this.gristByType[n] + (int)amount;
        return this;
    }

    public MutableGristSet add(GristSet set) {
        if (set instanceof SmallImmutableGristSet) {
            SmallImmutableGristSet smol = (SmallImmutableGristSet)set;
            for (int i = 0; i < this.gristByType.length; ++i) {
                int n = i;
                this.gristByType[n] = this.gristByType[n] + smol.gristByType[i];
            }
            return this;
        }
        for (Map.Entry entry : set.asMap().entrySet()) {
            this.add((GristType)entry.getKey(), (Long)entry.getValue());
        }
        return this;
    }

    public MutableGristSet scale(float scale, boolean roundDown) {
        for (int i = 0; i < this.gristByType.length; ++i) {
            int amount = this.gristByType[i];
            if (amount == 0) continue;
            this.gristByType[i] = roundDown ? (int)((float)amount * scale) : SmallMutableGristSet.roundToNonZero((float)amount * scale);
        }
        return this;
    }

    public GristSet.Immutable asImmutable() {
        return SmallImmutableGristSet.from((int[])this.gristByType.clone());
    }

    private static int roundToNonZero(float value) {
        if (value < 0.0f) {
            return Math.min(-1, Math.round(value));
        }
        return Math.max(1, Math.round(value));
    }
}

